/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.flowables.GroupedFlowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.EmptyComponent;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableGroupBy<T, K, V>
extends AbstractFlowableWithUpstream<T, GroupedFlowable<K, V>> {
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Function<? super Consumer<Object>, ? extends Map<K, Object>> mapFactory;

    public FlowableGroupBy(Flowable<T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Function<? super Consumer<Object>, ? extends Map<K, Object>> mapFactory) {
        super(source);
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.mapFactory = mapFactory;
    }

    @Override
    protected void subscribeActual(Subscriber<? super GroupedFlowable<K, V>> s) {
        ConcurrentHashMap groups;
        ConcurrentLinkedQueue evictedGroups;
        try {
            if (this.mapFactory == null) {
                evictedGroups = null;
                groups = new ConcurrentHashMap();
            } else {
                evictedGroups = new ConcurrentLinkedQueue();
                EvictionAction evictionAction = new EvictionAction(evictedGroups);
                groups = this.mapFactory.apply(evictionAction);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onSubscribe(EmptyComponent.INSTANCE);
            s.onError(e);
            return;
        }
        GroupBySubscriber<? super T, ? extends K, ? extends V> subscriber = new GroupBySubscriber<T, K, V>(s, this.keySelector, this.valueSelector, this.bufferSize, this.delayError, groups, evictedGroups);
        this.source.subscribe(subscriber);
    }

    static final class State<T, K>
    extends BasicIntQueueSubscription<T>
    implements Publisher<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final SpscLinkedArrayQueue<T> queue;
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        final AtomicLong requested = new AtomicLong();
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final AtomicReference<Subscriber<? super T>> actual = new AtomicReference();
        boolean outputFused;
        int produced;
        final AtomicInteger once = new AtomicInteger();
        static final int FRESH = 0;
        static final int HAS_SUBSCRIBER = 1;
        static final int ABANDONED = 2;
        static final int ABANDONED_HAS_SUBSCRIBER = 3;

        State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key, boolean delayError) {
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.parent = parent;
            this.key = key;
            this.delayError = delayError;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.cancelParent();
                this.drain();
            }
        }

        @Override
        public void subscribe(Subscriber<? super T> subscriber) {
            int s;
            while (((s = this.once.get()) & 1) == 0) {
                int u = s | 1;
                if (!this.once.compareAndSet(s, u)) continue;
                subscriber.onSubscribe(this);
                this.actual.lazySet(subscriber);
                if (this.cancelled.get()) {
                    this.actual.lazySet(null);
                } else {
                    this.drain();
                }
                return;
            }
            EmptySubscription.error(new IllegalStateException("Only one Subscriber allowed!"), subscriber);
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void cancelParent() {
            if ((this.once.get() & 2) == 0) {
                this.parent.cancel(this.key);
            }
        }

        boolean tryAbandon() {
            return this.once.get() == 0 && this.once.compareAndSet(0, 2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }

        void drainFused() {
            int missed = 1;
            SpscLinkedArrayQueue<T> q = this.queue;
            Subscriber<T> a = this.actual.get();
            while (true) {
                if (a != null) {
                    Throwable ex;
                    if (this.cancelled.get()) {
                        return;
                    }
                    boolean d = this.done;
                    if (d && !this.delayError && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    a.onNext(null);
                    if (d) {
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) {
                    return;
                }
                if (a != null) continue;
                a = this.actual.get();
            }
        }

        void drainNormal() {
            int missed = 1;
            SpscLinkedArrayQueue<T> q = this.queue;
            boolean delayError = this.delayError;
            Subscriber<T> a = this.actual.get();
            while (true) {
                if (a != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        boolean d = this.done;
                        T v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a, delayError, e)) {
                            return;
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, delayError, e)) {
                        return;
                    }
                    if (e != 0L) {
                        BackpressureHelper.produced(this.requested, e);
                        this.requestParent(e);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.actual.get();
            }
        }

        void requestParent(long e) {
            if ((this.once.get() & 2) == 0) {
                this.parent.requestGroup(e);
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, boolean delayError, long emitted) {
            if (this.cancelled.get()) {
                while (this.queue.poll() != null) {
                    ++emitted;
                }
                if (emitted != 0L) {
                    this.requestParent(emitted);
                }
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        void tryReplenish() {
            int p = this.produced;
            if (p != 0) {
                this.produced = 0;
                this.requestParent(p);
            }
        }

        @Override
        @Nullable
        public T poll() {
            T v = this.queue.poll();
            if (v != null) {
                ++this.produced;
                return v;
            }
            this.tryReplenish();
            return null;
        }

        @Override
        public boolean isEmpty() {
            if (this.queue.isEmpty()) {
                this.tryReplenish();
                return true;
            }
            this.tryReplenish();
            return false;
        }

        @Override
        public void clear() {
            SpscLinkedArrayQueue<T> q = this.queue;
            while (q.poll() != null) {
                ++this.produced;
            }
            this.tryReplenish();
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedFlowable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key, delayError);
            return new GroupedUnicast<K, T>(key, state);
        }

        protected GroupedUnicast(K key, State<T, K> state) {
            super(key);
            this.state = state;
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s) {
            this.state.subscribe(s);
        }

        public void onNext(T t) {
            this.state.onNext(t);
        }

        public void onError(Throwable e) {
            this.state.onError(e);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    static final class EvictionAction<K, V>
    implements Consumer<GroupedUnicast<K, V>> {
        final Queue<GroupedUnicast<K, V>> evictedGroups;

        EvictionAction(Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void accept(GroupedUnicast<K, V> value) {
            this.evictedGroups.offer(value);
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3688291656102519502L;
        final Subscriber<? super GroupedFlowable<K, V>> downstream;
        final Function<? super T, ? extends K> keySelector;
        final Function<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final int limit;
        final boolean delayError;
        final Map<Object, GroupedUnicast<K, V>> groups;
        final Queue<GroupedUnicast<K, V>> evictedGroups;
        static final Object NULL_KEY = new Object();
        Subscription upstream;
        final AtomicBoolean cancelled = new AtomicBoolean();
        long emittedGroups;
        final AtomicInteger groupCount = new AtomicInteger(1);
        final AtomicLong groupConsumed = new AtomicLong();
        boolean done;

        public GroupBySubscriber(Subscriber<? super GroupedFlowable<K, V>> actual, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Map<Object, GroupedUnicast<K, V>> groups, Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.downstream = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.delayError = delayError;
            this.groups = groups;
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(T t) {
            V v;
            K key;
            if (this.done) {
                return;
            }
            try {
                key = this.keySelector.apply(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key != null ? key : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.cancelled.get()) {
                    return;
                }
                group = GroupedUnicast.createWith(key, this.bufferSize, this, this.delayError);
                this.groups.put(mapKey, group);
                this.groupCount.getAndIncrement();
                newGroup = true;
            }
            try {
                v = ExceptionHelper.nullCheck(this.valueSelector.apply(t), "The valueSelector returned a null value.");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                if (newGroup) {
                    if (this.emittedGroups != this.get()) {
                        this.downstream.onNext(group);
                    } else {
                        MissingBackpressureException mbe = new MissingBackpressureException(GroupBySubscriber.groupHangWarning(this.emittedGroups));
                        mbe.initCause(ex);
                        this.onError(mbe);
                        return;
                    }
                }
                this.onError(ex);
                return;
            }
            group.onNext(v);
            this.completeEvictions();
            if (newGroup) {
                if (this.emittedGroups != this.get()) {
                    ++this.emittedGroups;
                    this.downstream.onNext(group);
                    if (group.state.tryAbandon()) {
                        this.cancel(key);
                        group.onComplete();
                        this.requestGroup(1L);
                    }
                } else {
                    this.upstream.cancel();
                    this.onError(new MissingBackpressureException(GroupBySubscriber.groupHangWarning(this.emittedGroups)));
                }
            }
        }

        static String groupHangWarning(long n) {
            return "Unable to emit a new group (#" + n + ") due to lack of requests. Please make sure the downstream can always accept a new group as well as each group is consumed in order for the whole operator to be able to proceed.";
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            for (GroupedUnicast<K, V> g : this.groups.values()) {
                g.onError(t);
            }
            this.groups.clear();
            if (this.evictedGroups != null) {
                this.evictedGroups.clear();
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                for (GroupedUnicast<K, V> g : this.groups.values()) {
                    g.onComplete();
                }
                this.groups.clear();
                if (this.evictedGroups != null) {
                    this.evictedGroups.clear();
                }
                this.done = true;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.completeEvictions();
                if (this.groupCount.decrementAndGet() == 0) {
                    this.upstream.cancel();
                }
            }
        }

        private void completeEvictions() {
            if (this.evictedGroups != null) {
                GroupedUnicast<K, V> evictedGroup;
                int count = 0;
                while ((evictedGroup = this.evictedGroups.poll()) != null) {
                    evictedGroup.onComplete();
                    ++count;
                }
                if (count != 0) {
                    this.groupCount.addAndGet(-count);
                }
            }
        }

        public void cancel(K key) {
            Object mapKey = key != null ? key : NULL_KEY;
            this.groups.remove(mapKey);
            if (this.groupCount.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }

        void requestGroup(long n) {
            long newConsumed;
            long currentConsumed;
            AtomicLong groupConsumed = this.groupConsumed;
            int limit = this.limit;
            while (!groupConsumed.compareAndSet(currentConsumed = groupConsumed.get(), newConsumed = BackpressureHelper.addCap(currentConsumed, n))) {
            }
            while (newConsumed >= (long)limit) {
                long newConsumedAfterLimit = newConsumed - (long)limit;
                if (groupConsumed.compareAndSet(newConsumed, newConsumedAfterLimit)) {
                    this.upstream.request(limit);
                }
                newConsumed = groupConsumed.get();
            }
            return;
        }
    }
}

