/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.HasProtoSchema;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMember;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;

public final class ProtoFieldMetadata
implements HasProtoSchema {
    private final int number;
    private final String name;
    private final XClass javaType;
    private final XClass collectionImplementation;
    private final Type protobufType;
    private final String documentation;
    private final ProtoTypeMetadata protoTypeMetadata;
    private final boolean isRequired;
    private final boolean isRepeated;
    private final boolean isArray;
    private final Object defaultValue;
    private final String propertyName;
    private final XMember declaringMember;
    private final XField field;
    private final XMethod getter;
    private final XMethod setter;

    ProtoFieldMetadata(int number, String name, XClass javaType, XClass collectionImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, boolean isArray, Object defaultValue, XField field) {
        this.number = number;
        this.name = name;
        this.javaType = javaType;
        this.collectionImplementation = collectionImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.isArray = isArray;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.declaringMember = field;
        this.field = field;
        this.getter = null;
        this.setter = null;
        this.documentation = field.getProtoDocs();
        this.propertyName = field.getName();
    }

    ProtoFieldMetadata(int number, String name, XClass javaType, XClass collectionImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, boolean isArray, Object defaultValue, String propertyName, XMethod definingMethod, XMethod getter, XMethod setter) {
        this.number = number;
        this.name = name;
        this.javaType = javaType;
        this.collectionImplementation = collectionImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.isArray = isArray;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.field = null;
        this.propertyName = propertyName;
        this.declaringMember = definingMethod;
        this.getter = getter;
        this.setter = setter;
        this.documentation = definingMethod.getProtoDocs();
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public XClass getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        String canonicalName = this.javaType.getCanonicalName();
        return canonicalName != null ? canonicalName : this.javaType.getName();
    }

    public XClass getCollectionImplementation() {
        return this.collectionImplementation;
    }

    public Type getProtobufType() {
        return this.protobufType;
    }

    public ProtoTypeMetadata getProtoTypeMetadata() {
        return this.protoTypeMetadata;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public XField getField() {
        return this.field;
    }

    public XMethod getGetter() {
        return this.getter;
    }

    public XMethod getSetter() {
        return this.setter;
    }

    public String getLocation() {
        return this.declaringMember instanceof XExecutable ? ((XExecutable)this.declaringMember).toGenericString() : this.declaringMember.toString();
    }

    @Override
    public void generateProto(IndentWriter iw) {
        String typeName;
        iw.append('\n');
        ProtoTypeMetadata.appendDocumentation(iw, this.documentation);
        if (this.isRepeated) {
            iw.append("repeated ");
        } else {
            iw.append(this.isRequired ? "required " : "optional ");
        }
        if (this.protobufType.getJavaType() == JavaType.ENUM || this.protobufType.getJavaType() == JavaType.MESSAGE) {
            typeName = this.protoTypeMetadata.getFullName();
        } else {
            switch (this.protobufType) {
                case DOUBLE: {
                    typeName = "double";
                    break;
                }
                case FLOAT: {
                    typeName = "float";
                    break;
                }
                case INT32: {
                    typeName = "int32";
                    break;
                }
                case INT64: {
                    typeName = "int64";
                    break;
                }
                case FIXED32: {
                    typeName = "fixed32";
                    break;
                }
                case FIXED64: {
                    typeName = "fixed64";
                    break;
                }
                case BOOL: {
                    typeName = "bool";
                    break;
                }
                case STRING: {
                    typeName = "string";
                    break;
                }
                case BYTES: {
                    typeName = "bytes";
                    break;
                }
                case UINT32: {
                    typeName = "uint32";
                    break;
                }
                case UINT64: {
                    typeName = "uint64";
                    break;
                }
                case SFIXED32: {
                    typeName = "sfixed32";
                    break;
                }
                case SFIXED64: {
                    typeName = "sfixed64";
                    break;
                }
                case SINT32: {
                    typeName = "sint32";
                    break;
                }
                case SINT64: {
                    typeName = "sint64";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type " + (Object)((Object)this.protobufType));
                }
            }
        }
        iw.append(typeName);
        iw.append(' ').append(this.name).append(" = ").append(String.valueOf(this.number));
        Object defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            String v = defaultValue instanceof ProtoEnumValueMetadata ? ((ProtoEnumValueMetadata)defaultValue).getProtoName() : (defaultValue instanceof Date ? Long.toString(((Date)defaultValue).getTime()) : (defaultValue instanceof Character ? Integer.toString(((Character)defaultValue).charValue()) : (defaultValue instanceof byte[] ? "\"" + new String(ProtoMessageTypeMetadata.cescape((byte[])defaultValue), StandardCharsets.ISO_8859_1) + "\"" : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : defaultValue.toString()))));
            iw.append(" [default = ").append(v).append(']');
        }
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ");
            if (this.field != null) {
                iw.append("field = ").append(this.field.getDeclaringClass().getCanonicalName()).append('.').append(this.field.getName());
            } else {
                iw.append("getter = ").append(this.getter.getDeclaringClass().getCanonicalName()).append('.').append(this.getter.getName());
                if (this.setter != null) {
                    iw.append(", setter = ").append(this.setter.getDeclaringClass().getCanonicalName()).append('.').append(this.setter.getName());
                }
            }
            iw.append(" */");
        }
        iw.append(";\n");
    }

    public boolean isBoxedPrimitive() {
        XTypeFactory factory = this.javaType.getFactory();
        return this.javaType == factory.fromClass(Float.class) || this.javaType == factory.fromClass(Double.class) || this.javaType == factory.fromClass(Long.class) || this.javaType == factory.fromClass(Integer.class) || this.javaType == factory.fromClass(Short.class) || this.javaType == factory.fromClass(Byte.class) || this.javaType == factory.fromClass(Boolean.class) || this.javaType == factory.fromClass(Character.class);
    }

    public String toString() {
        return "ProtoFieldMetadata{number=" + this.number + ", name='" + this.name + '\'' + ", protobufType=" + (Object)((Object)this.protobufType) + ", javaType=" + this.javaType + ", collectionImplementation=" + this.collectionImplementation + ", documentation='" + this.documentation + '\'' + ", protoTypeMetadata=" + (this.protoTypeMetadata != null ? this.protoTypeMetadata.getName() : null) + ", isRequired=" + this.isRequired + ", isRepeated=" + this.isRepeated + ", isArray=" + this.isArray + ", defaultValue=" + this.defaultValue + ", propertyName='" + this.propertyName + '\'' + ", declaringMember=" + this.declaringMember + ", field=" + this.field + ", getter=" + this.getter + ", setter=" + this.setter + '}';
    }
}

