/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.WireType;

public enum Type {
    DOUBLE(JavaType.DOUBLE, WireType.FIXED64),
    FLOAT(JavaType.FLOAT, WireType.FIXED32),
    INT64(JavaType.LONG, WireType.VARINT),
    UINT64(JavaType.LONG, WireType.VARINT),
    INT32(JavaType.INT, WireType.VARINT),
    FIXED64(JavaType.LONG, WireType.FIXED64),
    FIXED32(JavaType.INT, WireType.FIXED32),
    BOOL(JavaType.BOOLEAN, WireType.VARINT),
    STRING(JavaType.STRING, WireType.LENGTH_DELIMITED),
    BYTES(JavaType.BYTE_STRING, WireType.LENGTH_DELIMITED),
    UINT32(JavaType.INT, WireType.VARINT),
    SFIXED32(JavaType.INT, WireType.FIXED32),
    SFIXED64(JavaType.LONG, WireType.FIXED64),
    SINT32(JavaType.INT, WireType.VARINT),
    SINT64(JavaType.LONG, WireType.VARINT),
    GROUP(JavaType.MESSAGE, WireType.START_GROUP),
    MESSAGE(JavaType.MESSAGE, WireType.LENGTH_DELIMITED),
    ENUM(JavaType.ENUM, WireType.VARINT);

    private final JavaType javaType;
    private final WireType wireType;

    private Type(JavaType javaType, WireType wireType) {
        this.javaType = javaType;
        this.wireType = wireType;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public WireType getWireType() {
        return this.wireType;
    }

    public boolean isUnsigned() {
        return this == UINT32 || this == UINT64 || this == FIXED32 || this == FIXED64;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

