/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

public enum WireType {
    VARINT(0),
    FIXED64(1),
    LENGTH_DELIMITED(2),
    START_GROUP(3),
    END_GROUP(4),
    FIXED32(5);

    private static final WireType[] VALUES;
    public static final int WIRETYPE_VARINT = 0;
    public static final int WIRETYPE_FIXED64 = 1;
    public static final int WIRETYPE_LENGTH_DELIMITED = 2;
    public static final int WIRETYPE_START_GROUP = 3;
    public static final int WIRETYPE_END_GROUP = 4;
    public static final int WIRETYPE_FIXED32 = 5;
    public static final int TAG_TYPE_NUM_BITS = 3;
    public static final int TAG_TYPE_BIT_MASK = 7;
    public final int value;

    private WireType(int value) {
        this.value = value;
    }

    public static WireType fromValue(int wireType) {
        if (wireType < 0 || wireType >= VALUES.length) {
            throw new IllegalArgumentException("Invalid wire type " + wireType);
        }
        return VALUES[wireType];
    }

    public static WireType fromTag(int tag) {
        int wireType = WireType.getTagWireType(tag);
        if (wireType < 0 || wireType >= VALUES.length) {
            throw new IllegalArgumentException("Invalid wire type " + wireType + " in tag " + tag);
        }
        return VALUES[wireType];
    }

    public static int makeTag(int fieldNumber, WireType wireType) {
        return fieldNumber << 3 | wireType.value;
    }

    public static int getTagWireType(int tag) {
        return tag & 7;
    }

    public static int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    static {
        VALUES = new WireType[]{VARINT, FIXED64, LENGTH_DELIMITED, START_GROUP, END_GROUP, FIXED32};
    }
}

