/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import protostream.com.google.protobuf.CodedOutputStream;

public final class TagWriterImpl
implements TagWriter,
ProtobufTagMarshaller.WriteContext {
    private final CodedOutputStream delegate;
    private final SerializationContextImpl serCtx;
    private Map<Object, Object> params = null;
    private ProtoStreamWriterImpl writer = null;

    private TagWriterImpl(SerializationContextImpl serCtx, CodedOutputStream delegate) {
        this.serCtx = serCtx;
        this.delegate = delegate;
    }

    public static TagWriterImpl newNestedInstance(ProtobufTagMarshaller.WriteContext parentCtx, OutputStream output) {
        TagWriterImpl parent = (TagWriterImpl)parentCtx;
        TagWriterImpl nestedCtx = new TagWriterImpl(parent.serCtx, CodedOutputStream.newInstance(output));
        nestedCtx.params = parent.params;
        nestedCtx.writer = parent.writer;
        return nestedCtx;
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, OutputStream output) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, CodedOutputStream.newInstance(output));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, OutputStream output, int bufferSize) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, CodedOutputStream.newInstance(output, bufferSize));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, byte[] flatArray) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, CodedOutputStream.newInstance(flatArray));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, byte[] flatArray, int offset, int length) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, CodedOutputStream.newInstance(flatArray, offset, length));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, ByteBuffer byteBuffer) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, CodedOutputStream.newInstance(byteBuffer));
    }

    @Override
    public void writeTag(int number, int wireType) throws IOException {
        this.writeTag(number, WireType.fromValue(wireType));
    }

    @Override
    public void writeTag(int number, WireType wireType) throws IOException {
        this.delegate.writeTag(number, wireType.value);
    }

    @Override
    public void writeUInt32NoTag(int value) throws IOException {
        this.delegate.writeUInt32NoTag(value);
    }

    @Override
    public void writeUInt64NoTag(long value) throws IOException {
        this.delegate.writeUInt64NoTag(value);
    }

    @Override
    public void writeString(int number, String value) throws IOException {
        this.delegate.writeString(number, value);
    }

    @Override
    public void writeInt32(int number, int value) throws IOException {
        this.delegate.writeInt32(number, value);
    }

    @Override
    public void writeInt64(int number, long value) throws IOException {
        this.delegate.writeInt64(number, value);
    }

    @Override
    public void writeFixed32(int number, int value) throws IOException {
        this.delegate.writeFixed32(number, value);
    }

    @Override
    public void writeUInt32(int number, int value) throws IOException {
        this.delegate.writeUInt32(number, value);
    }

    @Override
    public void writeSFixed32(int number, int value) throws IOException {
        this.delegate.writeSFixed32(number, value);
    }

    @Override
    public void writeSInt32(int number, int value) throws IOException {
        this.delegate.writeSInt32(number, value);
    }

    @Override
    public void writeEnum(int number, int value) throws IOException {
        this.delegate.writeEnum(number, value);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void writeBool(int number, boolean value) throws IOException {
        this.delegate.writeBool(number, value);
    }

    @Override
    public void writeDouble(int number, double value) throws IOException {
        this.delegate.writeDouble(number, value);
    }

    @Override
    public void writeFloat(int number, float value) throws IOException {
        this.delegate.writeFloat(number, value);
    }

    @Override
    public void writeBytes(int number, ByteBuffer value) throws IOException {
        int off = value.arrayOffset();
        int len = value.limit() - off;
        this.delegate.writeByteArray(number, value.array(), off, len);
    }

    @Override
    public void writeBytes(int number, byte[] value) throws IOException {
        this.delegate.writeByteArray(number, value);
    }

    @Override
    public void writeBytes(int number, byte[] value, int offset, int length) throws IOException {
        this.delegate.writeByteArray(number, value, offset, length);
    }

    @Override
    public void writeUInt64(int number, long value) throws IOException {
        this.delegate.writeUInt64(number, value);
    }

    @Override
    public void writeFixed64(int number, long value) throws IOException {
        this.delegate.writeFixed64(number, value);
    }

    @Override
    public void writeSFixed64(int number, long value) throws IOException {
        this.delegate.writeSFixed64(number, value);
    }

    @Override
    public void writeSInt64(int number, long value) throws IOException {
        this.delegate.writeSInt64(number, value);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.delegate.writeRawBytes(value, offset, length);
    }

    @Override
    public SerializationContextImpl getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public Object getParam(Object key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    @Override
    public void setParam(Object key, Object value) {
        if (this.params == null) {
            this.params = new HashMap<Object, Object>();
        }
        this.params.put(key, value);
    }

    @Override
    public TagWriter getWriter() {
        return this;
    }

    @Deprecated
    public ProtoStreamWriterImpl getProtoStreamWriter() {
        if (this.writer == null) {
            this.writer = new ProtoStreamWriterImpl(this, this.serCtx);
        }
        return this.writer;
    }
}

