/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.function.BaseFunction;

public final class PutFunction<K, V>
implements BaseFunction<K, V, Void> {
    public static final AdvancedExternalizer<PutFunction> EXTERNALIZER = new Externalizer();
    private final V value;

    public PutFunction(V value) {
        this.value = value;
    }

    public Void apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Bucket<V> bucket = new Bucket<V>();
        bucket.add(this.value);
        entryView.find().map(bucket::addAll);
        entryView.set(bucket, new MetaParam.Writable[0]);
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<PutFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends PutFunction>> getTypeClasses() {
            return Collections.singleton(PutFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.PUT_KEY_VALUE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, PutFunction object) throws IOException {
            output.writeObject(object.value);
        }

        public PutFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new PutFunction(input.readObject());
        }
    }
}

