/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5307)
public class SortedSetBucket<V>
implements SortableBucket<V> {
    private final TreeSet<ScoredValue<V>> scoredEntries = new TreeSet();
    private final Map<MultimapObjectWrapper<V>, Double> entries;

    public Collection<ScoredValue<V>> union(Collection<ScoredValue<V>> inputValues, double weight, AggregateFunction function) {
        Double existingScore;
        TreeSet<ScoredValue<V>> sortedMergeScoredValues = new TreeSet<ScoredValue<V>>();
        HashMap<MultimapObjectWrapper<V>, Double> mergedEntries = new HashMap<MultimapObjectWrapper<V>, Double>();
        if (inputValues != null) {
            for (ScoredValue<V> element : inputValues) {
                existingScore = this.entries.get(element.wrappedValue());
                Double unionScore = existingScore == null ? element.score() : Double.valueOf(function.apply(element.score(), existingScore * weight));
                sortedMergeScoredValues.add(new ScoredValue<V>(unionScore, element.wrappedValue()));
                mergedEntries.put(element.wrappedValue(), unionScore);
            }
        }
        for (ScoredValue<V> element : this.scoredEntries) {
            existingScore = (Double)mergedEntries.get(element.wrappedValue());
            if (existingScore != null) continue;
            sortedMergeScoredValues.add(new ScoredValue<V>(element.score() * weight, element.wrappedValue()));
        }
        return sortedMergeScoredValues;
    }

    public Collection<ScoredValue<V>> inter(Collection<ScoredValue<V>> inputValues, double weight, AggregateFunction function) {
        if (inputValues == null) {
            return this.scoredEntries.stream().map(s -> new ScoredValue(s.score() * weight, s.wrappedValue())).collect(Collectors.toList());
        }
        TreeSet<ScoredValue<V>> sortedMergeScoredValues = new TreeSet<ScoredValue<V>>();
        for (ScoredValue<V> element : inputValues) {
            Double existingScore = this.entries.get(element.wrappedValue());
            if (existingScore == null) continue;
            double score = function.apply(element.score(), existingScore * weight);
            sortedMergeScoredValues.add(new ScoredValue<V>(score, element.wrappedValue()));
        }
        return sortedMergeScoredValues;
    }

    public List<ScoredValue<V>> randomMembers(int count) {
        if (count == 1 || count == -1) {
            int rank = ThreadLocalRandom.current().nextInt(this.scoredEntries.size());
            return this.subsetByIndex(rank, rank, false);
        }
        if (count < 0) {
            int totalCount = Math.abs(count);
            ArrayList<ScoredValue<V>> randomEntries = new ArrayList<ScoredValue<V>>(totalCount);
            ThreadLocalRandom.current().ints(totalCount, 0, this.entries.size()).forEach(randomPos -> randomEntries.add(this.subsetByIndex(randomPos, randomPos, false).get(0)));
            return randomEntries;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>(this.entries.size());
        while (positions.size() < this.entries.size()) {
            positions.add(positions.size());
        }
        Collections.shuffle(positions);
        ArrayList<ScoredValue<V>> randomEntries = new ArrayList<ScoredValue<V>>();
        Iterator ite = positions.iterator();
        while (randomEntries.size() < count && randomEntries.size() < this.entries.size()) {
            Integer pos = (Integer)ite.next();
            randomEntries.add(this.subsetByIndex(pos.intValue(), pos.intValue(), false).get(0));
        }
        return randomEntries;
    }

    @ProtoFactory
    SortedSetBucket(Collection<ScoredValue<V>> wrappedValues) {
        this.scoredEntries.addAll(wrappedValues);
        this.entries = new HashMap<MultimapObjectWrapper<V>, Double>();
        wrappedValues.forEach(e -> this.entries.put(e.wrappedValue(), e.score()));
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<ScoredValue<V>> getWrappedValues() {
        return new ArrayList<ScoredValue<V>>(this.scoredEntries);
    }

    public SortedSet<ScoredValue<V>> getScoredEntries() {
        return new TreeSet<ScoredValue<V>>(this.scoredEntries);
    }

    public List<ScoredValue<V>> getScoredEntriesAsList() {
        return new ArrayList<ScoredValue<V>>(this.scoredEntries);
    }

    public SortedSetBucket() {
        this.entries = new HashMap<MultimapObjectWrapper<V>, Double>();
    }

    public Collection<ScoredValue<V>> pop(boolean min, long count) {
        ArrayList<ScoredValue<V>> popValuesList = new ArrayList<ScoredValue<V>>();
        for (long i = 0L; i < count && !this.scoredEntries.isEmpty(); ++i) {
            ScoredValue<V> popedScoredValue = min ? this.scoredEntries.pollFirst() : this.scoredEntries.pollLast();
            this.entries.remove(popedScoredValue.wrappedValue());
            popValuesList.add(popedScoredValue);
        }
        return popValuesList;
    }

    public List<Double> scores(List<V> members) {
        return members.stream().map(m -> this.entries.get(new MultimapObjectWrapper<Object>(m))).collect(Collectors.toList());
    }

    public IndexValue indexOf(V member, boolean isRev) {
        MultimapObjectWrapper<V> wrapMember = new MultimapObjectWrapper<V>(member);
        Double score = this.entries.get(wrapMember);
        if (score == null) {
            return null;
        }
        SortedSet<ScoredValue<V>> tailedHead = this.scoredEntries.headSet(new ScoredValue<V>(score, wrapMember));
        return isRev ? IndexValue.of(score, this.scoredEntries.size() - tailedHead.size() - 1) : IndexValue.of(score, tailedHead.size());
    }

    public void replace(Collection<ScoredValue<V>> scoredValues) {
        this.entries.clear();
        this.scoredEntries.clear();
        for (ScoredValue<V> scoredValue : scoredValues) {
            this.addScoredValue(scoredValue);
        }
    }

    public Set<MultimapObjectWrapper<V>> getScoredEntriesAsValuesSet() {
        return this.entries.keySet().stream().collect(Collectors.toSet());
    }

    public AddOrUpdatesCounters addMany(Collection<ScoredValue<V>> scoredValues, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly) {
        AddOrUpdatesCounters addResult = new AddOrUpdatesCounters();
        int startSize = this.entries.size();
        for (ScoredValue<V> scoredValue : scoredValues) {
            if (addOnly) {
                this.addOnly(scoredValue);
                continue;
            }
            if (updateOnly) {
                this.updateOnly(addResult, scoredValue);
                continue;
            }
            if (updateGreaterScoresOnly) {
                this.addOrUpdateGreaterScores(addResult, scoredValue);
                continue;
            }
            if (updateLessScoresOnly) {
                this.addOrUpdateLessScores(addResult, scoredValue);
                continue;
            }
            this.addOrUpdate(addResult, scoredValue);
        }
        addResult.created = this.entries.size() - startSize;
        return addResult;
    }

    public Double incrScore(double incr, V member, boolean addOnly, boolean updateOnly, boolean updateLessScoresOnly, boolean updateGreaterScoresOnly) {
        MultimapObjectWrapper<V> wrappedValue = new MultimapObjectWrapper<V>(member);
        Double existingScore = this.entries.get(wrappedValue);
        if (existingScore != null && addOnly || existingScore == null && updateOnly) {
            return null;
        }
        Double newScore = existingScore == null ? incr : existingScore + incr;
        if (existingScore != null && (updateGreaterScoresOnly && newScore <= existingScore || updateLessScoresOnly && newScore >= existingScore)) {
            return null;
        }
        this.addOrUpdate(new AddOrUpdatesCounters(), new ScoredValue<V>(newScore, wrappedValue));
        return newScore;
    }

    private void addOnly(ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        }
    }

    private void updateOnly(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore != null && !existingScore.equals(scoredValue.score())) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdateGreaterScores(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        } else if (scoredValue.score() > existingScore) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdateLessScores(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        } else if (scoredValue.score() < existingScore) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void addOrUpdate(AddOrUpdatesCounters addResult, ScoredValue<V> scoredValue) {
        Double existingScore = this.entries.get(scoredValue.wrappedValue());
        if (existingScore == null) {
            this.addScoredValue(scoredValue);
        } else if (!scoredValue.score().equals(existingScore)) {
            this.updateScoredValue(scoredValue, existingScore);
            ++addResult.updated;
        }
    }

    private void updateScoredValue(ScoredValue<V> newScoredValue, Double existingScore) {
        ScoredValue<V> oldScoredValue = new ScoredValue<V>(existingScore, newScoredValue.wrappedValue());
        this.scoredEntries.remove(oldScoredValue);
        this.scoredEntries.add(newScoredValue);
        this.entries.put(newScoredValue.wrappedValue(), newScoredValue.score());
    }

    private void addScoredValue(ScoredValue<V> scoredValue) {
        this.scoredEntries.add(scoredValue);
        this.entries.put(scoredValue.wrappedValue(), scoredValue.score());
    }

    public <V> long removeAll(Collection<V> values) {
        long removeCount = 0L;
        for (V value : values) {
            MultimapObjectWrapper<V> wrappedValue = new MultimapObjectWrapper<V>(value);
            Double score = this.entries.get(wrappedValue);
            if (score == null) continue;
            this.entries.remove(wrappedValue);
            this.scoredEntries.remove(new ScoredValue<V>(score, wrappedValue));
            ++removeCount;
        }
        return removeCount;
    }

    public long removeAll(V min, boolean includeMin, V max, boolean includeMax) {
        List<ScoredValue<V>> subset = this.subset(min, includeMin, max, includeMax, false, null, null);
        for (ScoredValue<V> value : subset) {
            this.entries.remove(value.wrappedValue());
            this.scoredEntries.remove(value);
        }
        return subset.size();
    }

    public long removeAll(Double min, boolean includeMin, Double max, boolean includeMax) {
        List<ScoredValue<Double>> subset = this.subset((V)min, includeMin, (V)max, includeMax, false, null, null);
        for (ScoredValue<Double> value : subset) {
            this.entries.remove(value.wrappedValue());
            this.scoredEntries.remove(value);
        }
        return subset.size();
    }

    public long removeAll(Long min, Long max) {
        List<ScoredValue<V>> subset = this.subsetByIndex(min, max, false);
        for (ScoredValue<V> value : subset) {
            this.entries.remove(value.wrappedValue());
            this.scoredEntries.remove(value);
        }
        return subset.size();
    }

    public List<ScoredValue<V>> subsetByIndex(long from, long to, boolean rev) {
        long pos;
        long toIte;
        if (from > 0L && to > 0L && from > to || from < 0L && to < 0L && from > to) {
            return Collections.emptyList();
        }
        long fromIte = from < 0L ? (long)this.scoredEntries.size() + from : from;
        long l = toIte = to < 0L ? (long)this.scoredEntries.size() + to : to;
        if (fromIte > toIte) {
            return Collections.emptyList();
        }
        ArrayList<ScoredValue<V>> results = new ArrayList<ScoredValue<V>>();
        Iterator<ScoredValue<V>> ite = rev ? this.scoredEntries.descendingIterator() : this.scoredEntries.iterator();
        for (pos = 0L; pos < fromIte && ite.hasNext(); ++pos) {
            ite.next();
        }
        while (pos <= toIte && ite.hasNext()) {
            results.add(ite.next());
            ++pos;
        }
        return results;
    }

    public List<ScoredValue<V>> subset(Double startScore, boolean includeStart, Double stopScore, boolean includeStop, boolean isRev, Long offset, Long count) {
        ScoredValue<V> stopSv;
        ScoredValue<V> startSv;
        boolean unboundedMax;
        if (stopScore != null && stopScore.equals(startScore) && (!includeStart || !includeStop) || count != null && count == 0L || offset != null && offset.equals(this.entries.size())) {
            return Collections.emptyList();
        }
        Double min = isRev ? stopScore : startScore;
        boolean includeMin = isRev ? includeStop : includeStart;
        Double max = isRev ? startScore : stopScore;
        boolean includeMax = isRev ? includeStart : includeStop;
        boolean unboundedMin = min == null || min == Double.MIN_VALUE;
        boolean bl = unboundedMax = max == null || max == Double.MAX_VALUE;
        if (unboundedMin && unboundedMax) {
            return this.applyLimit(this.scoredEntries, offset, count, isRev);
        }
        if (unboundedMin) {
            startSv = this.scoredEntries.first();
        } else {
            startSv = includeMin ? this.scoredEntries.lower(ScoredValue.of(min)) : this.scoredEntries.higher(ScoredValue.of(min));
            if (startSv == null) {
                startSv = this.scoredEntries.first();
            }
        }
        if (unboundedMax) {
            stopSv = this.scoredEntries.last();
        } else {
            stopSv = includeMax ? this.scoredEntries.higher(ScoredValue.of(max)) : this.scoredEntries.lower(ScoredValue.of(max));
            if (stopSv == null) {
                stopSv = this.scoredEntries.last();
            }
        }
        if (startSv.score() > stopSv.score()) {
            return Collections.emptyList();
        }
        NavigableSet<ScoredValue<V>> subset = this.scoredEntries.subSet(startSv, unboundedMin || startSv.score() > min || includeMin && startSv.score().equals(min), stopSv, unboundedMax || stopSv.score() < max || includeMax && stopSv.score().equals(max));
        return this.applyLimit(subset, offset, count, isRev);
    }

    public List<ScoredValue<V>> subset(V startValue, boolean includeStart, V stopValue, boolean includeStop, boolean isRev, Long offset, Long count) {
        boolean unboundedMax;
        boolean includeMax;
        V minValue = isRev ? stopValue : startValue;
        V maxValue = isRev ? startValue : stopValue;
        boolean includeMin = isRev ? includeStop : includeStart;
        boolean bl = includeMax = isRev ? includeStart : includeStop;
        if (maxValue != null && maxValue.equals(minValue) && (!includeMin || !includeMax) || offset != null && offset.equals(this.entries.size()) || count != null && count == 0L) {
            return Collections.emptyList();
        }
        boolean unboundedMin = minValue == null;
        boolean bl2 = unboundedMax = maxValue == null;
        if (unboundedMin && unboundedMax) {
            return this.applyLimit(this.scoredEntries, offset, count, isRev);
        }
        double score = this.scoredEntries.first().score();
        ScoredValue<V> minScoredValue = ScoredValue.of(score, minValue);
        ScoredValue<V> maxScoredValue = ScoredValue.of(score, maxValue);
        if (unboundedMin) {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.headSet(maxScoredValue, includeMax);
            return this.applyLimit(entries, offset, count, isRev);
        }
        if (unboundedMax) {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.tailSet(minScoredValue, includeMin);
            return this.applyLimit(entries, offset, count, isRev);
        }
        try {
            NavigableSet<ScoredValue<V>> entries = this.scoredEntries.subSet(minScoredValue, includeMin, maxScoredValue, includeMax);
            return this.applyLimit(entries, offset, count, isRev);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    private List<ScoredValue<V>> applyLimit(NavigableSet<ScoredValue<V>> subset, Long offset, Long count, boolean isRev) {
        Iterator<ScoredValue<V>> ite;
        if (!SortedSetBucket.isLimited(offset, count)) {
            Iterator<ScoredValue<V>> ite2;
            ArrayList<ScoredValue<V>> result = new ArrayList<ScoredValue<V>>(this.entries.size());
            Iterator<ScoredValue<V>> iterator = ite2 = isRev ? subset.descendingIterator() : subset.iterator();
            while (ite2.hasNext()) {
                result.add(ite2.next());
            }
            return result;
        }
        ArrayList<ScoredValue<V>> result = new ArrayList<ScoredValue<V>>();
        Iterator<ScoredValue<V>> iterator = ite = isRev ? subset.descendingIterator() : subset.iterator();
        if (count < 0L) {
            this.skipOffset(offset, ite);
            while (ite.hasNext()) {
                result.add(ite.next());
            }
        } else {
            this.skipOffset(offset, ite);
            long localCount = 0L;
            while (ite.hasNext() && localCount++ < count) {
                result.add(ite.next());
            }
        }
        return result;
    }

    private void skipOffset(Long offset, Iterator<ScoredValue<V>> ite) {
        long localOffset = 0L;
        while (localOffset++ < offset && ite.hasNext()) {
            ite.next();
        }
    }

    private static boolean isLimited(Long offset, Long count) {
        return offset != null && count != null;
    }

    public Collection<ScoredValue<V>> toTreeSet() {
        return new TreeSet<ScoredValue<V>>(this.scoredEntries);
    }

    public long size() {
        return this.scoredEntries.size();
    }

    @Override
    public Stream<MultimapObjectWrapper<V>> stream() {
        return this.scoredEntries.stream().map(v -> v.wrappedValue());
    }

    @Override
    public List<ScoredValue<V>> sort(SortableBucket.SortOptions sortOptions) {
        Stream scoredValueStream = sortOptions.alpha ? this.scoredEntries.stream().map(v -> new ScoredValue(1.0, v.wrappedValue())) : this.scoredEntries.stream().map(v -> new ScoredValue(v.wrappedValue().asDouble(), v.wrappedValue()));
        return this.sort(scoredValueStream, sortOptions);
    }

    public static enum AggregateFunction {
        SUM{

            @Override
            public double apply(double first, double second) {
                return first + second;
            }
        }
        ,
        MIN{

            @Override
            public double apply(double first, double second) {
                return first < second ? first : second;
            }
        }
        ,
        MAX{

            @Override
            public double apply(double first, double second) {
                return first > second ? first : second;
            }
        };

        private static final AggregateFunction[] CACHED_VALUES;

        public static AggregateFunction valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        public abstract double apply(double var1, double var3);

        static {
            CACHED_VALUES = AggregateFunction.values();
        }
    }

    public static class IndexValue {
        private final double score;
        private final long index;

        private IndexValue(double score, long index) {
            this.score = score;
            this.index = index;
        }

        public static IndexValue of(double score, long index) {
            return new IndexValue(score, index);
        }

        public long getValue() {
            return this.index;
        }

        public double getScore() {
            return this.score;
        }
    }

    public static class AddOrUpdatesCounters {
        public long created = 0L;
        public long updated = 0L;
    }
}

