/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapPutFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Integer> {
    public static final AdvancedExternalizer<HashMapPutFunction> EXTERNALIZER = new Externalizer();
    private final Collection<Map.Entry<HK, HV>> entries;

    public HashMapPutFunction(Collection<Map.Entry<HK, HV>> entries) {
        this.entries = entries;
    }

    public Integer apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        int res;
        HashMapBucket bucket;
        Map<Object, Object> values = this.entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Optional existing = view.peek();
        if (existing.isPresent()) {
            bucket = (HashMapBucket)existing.get();
            res = bucket.putAll(values);
        } else {
            bucket = HashMapBucket.create(values);
            res = values.size();
        }
        view.set((Object)bucket, new MetaParam.Writable[0]);
        return res;
    }

    public static class Externalizer
    implements AdvancedExternalizer<HashMapPutFunction> {
        public Set<Class<? extends HashMapPutFunction>> getTypeClasses() {
            return Collections.singleton(HashMapPutFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_PUT_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapPutFunction object) throws IOException {
            output.writeInt(object.entries.size());
            Collection e = object.entries;
            for (Map.Entry entry : e) {
                output.writeObject(entry.getKey());
                output.writeObject(entry.getValue());
            }
        }

        public HashMapPutFunction<?, ?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            HashMap<Object, Object> values = new HashMap<Object, Object>(size);
            for (int i = 0; i < size; ++i) {
                values.put(input.readObject(), input.readObject());
            }
            return new HashMapPutFunction(values.entrySet());
        }
    }
}

