/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Map;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.multimap.impl.PersistenceContextInitializerImpl;
import org.infinispan.multimap.impl.function.hmap.HashMapKeySetFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapPutFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapRemoveFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapReplaceFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapValuesFunction;
import org.infinispan.multimap.impl.function.list.IndexFunction;
import org.infinispan.multimap.impl.function.list.IndexOfFunction;
import org.infinispan.multimap.impl.function.list.InsertFunction;
import org.infinispan.multimap.impl.function.list.OfferFunction;
import org.infinispan.multimap.impl.function.list.PollFunction;
import org.infinispan.multimap.impl.function.list.RemoveCountFunction;
import org.infinispan.multimap.impl.function.list.ReplaceListFunction;
import org.infinispan.multimap.impl.function.list.RotateFunction;
import org.infinispan.multimap.impl.function.list.SetFunction;
import org.infinispan.multimap.impl.function.list.SubListFunction;
import org.infinispan.multimap.impl.function.list.TrimFunction;
import org.infinispan.multimap.impl.function.multimap.ContainsFunction;
import org.infinispan.multimap.impl.function.multimap.GetFunction;
import org.infinispan.multimap.impl.function.multimap.PutFunction;
import org.infinispan.multimap.impl.function.multimap.RemoveFunction;
import org.infinispan.multimap.impl.function.set.SAddFunction;
import org.infinispan.multimap.impl.function.set.SGetFunction;
import org.infinispan.multimap.impl.function.set.SPopFunction;
import org.infinispan.multimap.impl.function.set.SRemoveFunction;
import org.infinispan.multimap.impl.function.set.SSetFunction;
import org.infinispan.multimap.impl.function.sortedset.AddManyFunction;
import org.infinispan.multimap.impl.function.sortedset.CountFunction;
import org.infinispan.multimap.impl.function.sortedset.IncrFunction;
import org.infinispan.multimap.impl.function.sortedset.IndexOfSortedSetFunction;
import org.infinispan.multimap.impl.function.sortedset.PopFunction;
import org.infinispan.multimap.impl.function.sortedset.RemoveManyFunction;
import org.infinispan.multimap.impl.function.sortedset.ScoreFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetAggregateFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetRandomFunction;
import org.infinispan.multimap.impl.function.sortedset.SubsetFunction;
import org.infinispan.protostream.SerializationContextInitializer;

@InfinispanModule(name="multimap", requiredModules={"core"})
public class MultimapModuleLifecycle
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        MultimapModuleLifecycle.addMultimapExternalizers(externalizerMap);
        MultimapModuleLifecycle.addListsExternalizers(externalizerMap);
        MultimapModuleLifecycle.addSetExternalizers(externalizerMap);
        MultimapModuleLifecycle.addHashMapExternalizers(externalizerMap);
        MultimapModuleLifecycle.addSortedSetExternalizers(externalizerMap);
    }

    private static void addMultimapExternalizers(Map<Integer, AdvancedExternalizer<?>> externalizerMap) {
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, PutFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, ContainsFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, GetFunction.EXTERNALIZER);
    }

    private static void addListsExternalizers(Map<Integer, AdvancedExternalizer<?>> externalizerMap) {
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, OfferFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, IndexFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, PollFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SubListFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, IndexOfFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, InsertFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveCountFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, TrimFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, RotateFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, ReplaceListFunction.EXTERNALIZER);
    }

    private static void addHashMapExternalizers(Map<Integer, AdvancedExternalizer<?>> externalizerMap) {
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, HashMapPutFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, HashMapKeySetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, HashMapValuesFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, HashMapRemoveFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, HashMapReplaceFunction.EXTERNALIZER);
    }

    private static void addSetExternalizers(Map<Integer, AdvancedExternalizer<?>> externalizerMap) {
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SAddFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SGetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SSetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SRemoveFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SPopFunction.EXTERNALIZER);
    }

    private static void addSortedSetExternalizers(Map<Integer, AdvancedExternalizer<?>> externalizerMap) {
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, AddManyFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, CountFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, PopFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, ScoreFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SubsetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, IndexOfSortedSetFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, IncrFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SortedSetAggregateFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, RemoveManyFunction.EXTERNALIZER);
        MultimapModuleLifecycle.addAdvancedExternalizer(externalizerMap, SortedSetRandomFunction.EXTERNALIZER);
    }

    private static void addAdvancedExternalizer(Map<Integer, AdvancedExternalizer<?>> map, AdvancedExternalizer<?> ext) {
        map.put(ext.getId(), ext);
    }
}

