/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class ReplaceListFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<ReplaceListFunction> EXTERNALIZER = new Externalizer();
    private final List<V> values;

    public ReplaceListFunction(List<V> values) {
        this.values = values;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        ListBucket<V> bucket = null;
        if (existing.isPresent()) {
            bucket = (ListBucket<V>)existing.get();
        } else if (this.values != null && !this.values.isEmpty()) {
            bucket = new ListBucket<V>();
        }
        if (bucket != null) {
            bucket.replace(this.values);
            if (bucket.isEmpty()) {
                entryView.remove();
            } else {
                entryView.set(bucket, new MetaParam.Writable[0]);
            }
            return bucket.size();
        }
        return 0L;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ReplaceListFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends ReplaceListFunction>> getTypeClasses() {
            return Collections.singleton(ReplaceListFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.REPLACE_LIST_FUNCTION;
        }

        public void writeObject(ObjectOutput output, ReplaceListFunction object) throws IOException {
            MarshallUtil.marshallCollection(object.values, (ObjectOutput)output);
        }

        public ReplaceListFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            List values = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            return new ReplaceListFunction(values);
        }
    }
}

