/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class RotateFunction<K, V>
implements ListBucketBaseFunction<K, V, V> {
    public static final AdvancedExternalizer<RotateFunction> EXTERNALIZER = new Externalizer();
    private final boolean rotateRight;

    public RotateFunction(boolean rotateRight) {
        this.rotateRight = rotateRight;
    }

    public V apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((ListBucket)existing.get()).rotate(this.rotateRight);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<RotateFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends RotateFunction>> getTypeClasses() {
            return Collections.singleton(RotateFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.ROTATE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, RotateFunction object) throws IOException {
            output.writeBoolean(object.rotateRight);
        }

        public RotateFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RotateFunction(input.readBoolean());
        }
    }
}

