/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.api.MultimapCache;
import org.infinispan.multimap.impl.function.ContainsFunction;
import org.infinispan.multimap.impl.function.GetFunction;
import org.infinispan.multimap.impl.function.PutFunction;
import org.infinispan.multimap.impl.function.RemoveFunction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializablePredicate;
import org.infinispan.util.function.SerializableToLongFunction;

public class EmbeddedMultimapCache<K, V>
implements MultimapCache<K, V> {
    private FunctionalMap.ReadWriteMap<K, Collection<V>> readWriteMap;
    private Cache<K, Collection<V>> cache;

    public EmbeddedMultimapCache(Cache<K, Collection<V>> cache) {
        this.cache = cache;
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)this.cache.getAdvancedCache());
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
    }

    @Override
    public CompletableFuture<Void> put(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new PutFunction(value));
    }

    @Override
    public CompletableFuture<Collection<V>> get(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new GetFunction());
    }

    @Override
    public CompletableFuture<Optional<CacheEntry<K, Collection<V>>>> getEntry(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(this.cache.getAdvancedCache().getCacheEntry(key)));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction());
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction(value));
    }

    @Override
    public CompletableFuture<Void> remove(Predicate<? super V> p) {
        Objects.requireNonNull(p, "predicate can't be null");
        CompletableFuture<Void> cf = CompletableFutures.completedNull();
        try {
            cf = this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.removeInternal(p)) : CompletableFuture.runAsync(() -> this.removeInternal(p));
        }
        catch (SystemException e) {
            CompletableFutures.rethrowException((Throwable)e);
        }
        return cf;
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction());
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        Objects.requireNonNull(value, "value can't be null");
        CompletableFuture<Boolean> cf = CompletableFutures.completedNull();
        try {
            cf = this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.containsEntryInternal(value)) : CompletableFuture.supplyAsync(() -> this.containsEntryInternal(value));
        }
        catch (SystemException e) {
            CompletableFutures.rethrowException((Throwable)e);
        }
        return cf;
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction(value));
    }

    @Override
    public CompletableFuture<Long> size() {
        CompletableFuture<Long> cf = CompletableFutures.completedNull();
        try {
            cf = this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.sizeInternal()) : CompletableFuture.supplyAsync(() -> this.sizeInternal());
        }
        catch (SystemException e) {
            CompletableFutures.rethrowException((Throwable)e);
        }
        return cf;
    }

    private boolean isExplicitTxContext() throws SystemException {
        TransactionManager transactionManager = this.cache.getAdvancedCache().getTransactionManager();
        return transactionManager != null && transactionManager.getTransaction() != null;
    }

    private Void removeInternal(Predicate<? super V> p) {
        this.cache.keySet().stream().forEach((SerializableBiConsumer & Serializable)(c, key) -> c.computeIfPresent(key, (SerializableBiFunction & Serializable)(o, o1) -> {
            Collection values = (Collection)o1;
            HashSet newValues = new HashSet();
            for (Object v : values) {
                if (p.test((Object)v)) continue;
                newValues.add(v);
            }
            return newValues.isEmpty() ? null : newValues;
        }));
        return null;
    }

    private Boolean containsEntryInternal(V value) {
        return this.cache.entrySet().parallelStream().anyMatch((SerializablePredicate & Serializable)entry -> ((Collection)entry.getValue()).contains(value));
    }

    private Long sizeInternal() {
        return this.cache.values().parallelStream().mapToLong((SerializableToLongFunction & Serializable)value -> value.size()).sum();
    }

    @Override
    public boolean supportsDuplicates() {
        return false;
    }

    public Cache<K, Collection<V>> getCache() {
        return this.cache;
    }
}

