/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.concurrent.BlockingQueue;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.LogRequest;
import org.infinispan.persistence.sifs.SyncProcessingQueue;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.logging.LogFactory;

public class LogAppender
extends Thread {
    private static final Log log = (Log)LogFactory.getLog(LogAppender.class, Log.class);
    private final SyncProcessingQueue<LogRequest> queue;
    private final BlockingQueue<IndexRequest> indexQueue;
    private final boolean syncWrites;
    private final TemporaryTable temporaryTable;
    private final int maxFileSize;
    private final Compactor compactor;
    private final FileProvider fileProvider;
    private LogRequest pausedRequest;
    private long seqId = 0L;

    LogAppender(SyncProcessingQueue<LogRequest> inboundQueue, BlockingQueue<IndexRequest> indexQueue, TemporaryTable temporaryTable, Compactor compactor, FileProvider fileProvider, boolean syncWrites, int maxFileSize) {
        super("BCS-LogAppender");
        this.setDaemon(true);
        this.queue = inboundQueue;
        this.indexQueue = indexQueue;
        this.temporaryTable = temporaryTable;
        this.compactor = compactor;
        this.fileProvider = fileProvider;
        this.syncWrites = syncWrites;
        this.maxFileSize = maxFileSize;
        this.start();
    }

    public void setSeqId(long seqId) {
        this.seqId = seqId;
    }

    public void pause() throws InterruptedException {
        LogRequest pause = LogRequest.pauseRequest();
        this.queue.pushAndWait(pause);
        this.pausedRequest = pause;
    }

    public void clearAndPause() throws InterruptedException {
        LogRequest clear = LogRequest.clearRequest();
        this.queue.pushAndWait(clear);
        this.pausedRequest = clear;
    }

    public void resumeAfterPause() {
        this.pausedRequest.resume();
        this.pausedRequest = null;
    }

    @Override
    public void run() {
        try {
            FileProvider.Log logFile = this.fileProvider.getFileForLog();
            int currentOffset = 0;
            while (true) {
                LogRequest request;
                if ((request = this.queue.pop()) != null) {
                    if (request.isClear()) {
                        logFile.close();
                        this.queue.notifyNoWait();
                        request.pause();
                        currentOffset = 0;
                        logFile = this.fileProvider.getFileForLog();
                        log.debug("Appending records to " + logFile.fileId);
                        continue;
                    }
                    if (request.isStop()) {
                        this.queue.notifyNoWait();
                        break;
                    }
                    if (request.isPause()) {
                        this.queue.notifyNoWait();
                        request.pause();
                        continue;
                    }
                    if (currentOffset + request.length() > this.maxFileSize) {
                        logFile.close();
                        this.compactor.completeFile(logFile.fileId);
                        currentOffset = 0;
                        logFile = this.fileProvider.getFileForLog();
                        log.debug("Appending records to " + logFile.fileId);
                    }
                    long seqId = this.nextSeqId();
                    EntryRecord.writeEntry(logFile.fileChannel, request.getSerializedKey(), request.getSerializedMetadata(), request.getSerializedValue(), seqId, request.getExpiration(), request.getCreated(), request.getLastUsed());
                    int offset = request.getSerializedValue() == null ? ~currentOffset : currentOffset;
                    this.temporaryTable.set(request.getKey(), logFile.fileId, offset);
                    IndexRequest indexRequest = IndexRequest.update(request.getKey(), this.raw(request.getSerializedKey()), logFile.fileId, offset, request.length());
                    request.setIndexRequest(indexRequest);
                    this.indexQueue.put(indexRequest);
                    currentOffset += request.length();
                    continue;
                }
                if (this.syncWrites) {
                    logFile.fileChannel.force(false);
                }
                this.queue.notifyAndWait();
            }
        }
        catch (Exception e) {
            this.queue.notifyError();
            throw new RuntimeException(e);
        }
    }

    private byte[] raw(ByteBuffer buffer) {
        if (buffer.getBuf().length == buffer.getLength()) {
            return buffer.getBuf();
        }
        byte[] bytes = new byte[buffer.getLength()];
        System.arraycopy(buffer.getBuf(), buffer.getOffset(), bytes, 0, buffer.getLength());
        return bytes;
    }

    private final long nextSeqId() {
        return this.seqId++;
    }

    public void stopOperations() throws InterruptedException {
        this.queue.pushAndWait(LogRequest.stopRequest());
        this.join();
    }
}

