/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.NestingAttributeSerializer;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.sifs.SoftIndexFileStore;
import org.infinispan.persistence.sifs.configuration.Element;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreSerializer;

@BuiltBy(value=SoftIndexFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SoftIndexFileStore.class)
@SerializedWith(value=SoftIndexFileStoreSerializer.class)
public class SoftIndexFileStoreConfiguration
extends AbstractSegmentedStoreConfiguration<SoftIndexFileStoreConfiguration>
implements ConfigurationInfo {
    private static AttributeSerializer UNDER_DATA = new NestingAttributeSerializer(Element.DATA.getLocalName());
    private static AttributeSerializer UNDER_INDEX = new NestingAttributeSerializer(Element.INDEX.getLocalName());
    public static final AttributeDefinition<String> DATA_LOCATION = AttributeDefinition.builder((String)"dataLocation", (Object)"Infinispan-SoftIndexFileStore-Data").immutable().autoPersist(false).serializer(UNDER_DATA).xmlName("path").build();
    public static final AttributeDefinition<String> INDEX_LOCATION = AttributeDefinition.builder((String)"indexLocation", (Object)"Infinispan-SoftIndexFileStore-Index").immutable().serializer(UNDER_INDEX).autoPersist(false).xmlName("path").build();
    public static final AttributeDefinition<Integer> INDEX_SEGMENTS = AttributeDefinition.builder((String)"indexSegments", (Object)3).immutable().serializer(UNDER_INDEX).autoPersist(false).xmlName("segments").build();
    public static final AttributeDefinition<Integer> MAX_FILE_SIZE = AttributeDefinition.builder((String)"maxFileSize", (Object)0x1000000).immutable().serializer(UNDER_DATA).autoPersist(false).build();
    public static final AttributeDefinition<Integer> MIN_NODE_SIZE = AttributeDefinition.builder((String)"minNodeSize", (Object)0).immutable().serializer(UNDER_INDEX).autoPersist(false).build();
    public static final AttributeDefinition<Integer> MAX_NODE_SIZE = AttributeDefinition.builder((String)"maxNodeSize", (Object)4096).immutable().serializer(UNDER_INDEX).autoPersist(false).build();
    public static final AttributeDefinition<Integer> INDEX_QUEUE_LENGTH = AttributeDefinition.builder((String)"indexQueueLength", (Object)1000).immutable().serializer(UNDER_INDEX).autoPersist(false).xmlName("max-queue-length").build();
    public static final AttributeDefinition<Boolean> SYNC_WRITES = AttributeDefinition.builder((String)"syncWrites", (Object)false).immutable().serializer(UNDER_DATA).autoPersist(false).build();
    public static final AttributeDefinition<Integer> OPEN_FILES_LIMIT = AttributeDefinition.builder((String)"openFilesLimit", (Object)1000).immutable().build();
    public static final AttributeDefinition<Double> COMPACTION_THRESHOLD = AttributeDefinition.builder((String)"compactionThreshold", (Object)0.5).immutable().build();
    public static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SOFT_INDEX_FILE_STORE.getLocalName());

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SoftIndexFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{DATA_LOCATION, INDEX_LOCATION, INDEX_SEGMENTS, MAX_FILE_SIZE, MIN_NODE_SIZE, MAX_NODE_SIZE, INDEX_QUEUE_LENGTH, SYNC_WRITES, OPEN_FILES_LIMIT, COMPACTION_THRESHOLD});
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public SoftIndexFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(attributes, async, singletonStore);
    }

    public SoftIndexFileStoreConfiguration newConfigurationFrom(int segment) {
        AttributeSet set = SoftIndexFileStoreConfiguration.attributeDefinitionSet();
        set.read(this.attributes);
        String dataLocation = (String)set.attribute(DATA_LOCATION).get();
        set.attribute(DATA_LOCATION).set((Object)SoftIndexFileStoreConfiguration.fileLocationTransform((String)dataLocation, (int)segment));
        String indexLocation = (String)set.attribute(INDEX_LOCATION).get();
        set.attribute(INDEX_LOCATION).set((Object)SoftIndexFileStoreConfiguration.fileLocationTransform((String)indexLocation, (int)segment));
        return new SoftIndexFileStoreConfiguration(set.protect(), this.async(), this.singletonStore());
    }

    public String dataLocation() {
        return (String)this.attributes.attribute(DATA_LOCATION).get();
    }

    public String indexLocation() {
        return (String)this.attributes.attribute(INDEX_LOCATION).get();
    }

    public int indexSegments() {
        return (Integer)this.attributes.attribute(INDEX_SEGMENTS).get();
    }

    public int maxFileSize() {
        return (Integer)this.attributes.attribute(MAX_FILE_SIZE).get();
    }

    public int minNodeSize() {
        return (Integer)this.attributes.attribute(MIN_NODE_SIZE).get();
    }

    public int maxNodeSize() {
        return (Integer)this.attributes.attribute(MAX_NODE_SIZE).get();
    }

    public int indexQueueLength() {
        return (Integer)this.attributes.attribute(INDEX_QUEUE_LENGTH).get();
    }

    public boolean syncWrites() {
        return (Boolean)this.attributes.attribute(SYNC_WRITES).get();
    }

    public int openFilesLimit() {
        return (Integer)this.attributes.attribute(OPEN_FILES_LIMIT).get();
    }

    public double compactionThreshold() {
        return (Double)this.attributes.attribute(COMPACTION_THRESHOLD).get();
    }
}

