/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.util.logging.LogFactory;

public class SoftIndexFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SoftIndexFileStoreConfiguration, SoftIndexFileStoreConfigurationBuilder>
implements ConfigurationBuilderInfo {
    private static final Log log = (Log)LogFactory.getLog(SoftIndexFileStoreConfigurationBuilder.class, Log.class);

    public SoftIndexFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, SoftIndexFileStoreConfiguration.attributeDefinitionSet());
    }

    public ElementDefinition getElementDefinition() {
        return SoftIndexFileStoreConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SoftIndexFileStoreConfigurationBuilder dataLocation(String dataLocation) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.DATA_LOCATION).set((Object)dataLocation);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexLocation(String indexLocation) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.INDEX_LOCATION).set((Object)indexLocation);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexSegments(int indexSegments) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.INDEX_SEGMENTS).set((Object)indexSegments);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxFileSize(int maxFileSize) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.MAX_FILE_SIZE).set((Object)maxFileSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder minNodeSize(int minNodeSize) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.MIN_NODE_SIZE).set((Object)minNodeSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.MAX_NODE_SIZE).set((Object)maxNodeSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.INDEX_QUEUE_LENGTH).set((Object)indexQueueLength);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder syncWrites(boolean syncWrites) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.SYNC_WRITES).set((Object)syncWrites);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder openFilesLimit(int openFilesLimit) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.OPEN_FILES_LIMIT).set((Object)openFilesLimit);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder compactionThreshold(double compactionThreshold) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.COMPACTION_THRESHOLD).set((Object)compactionThreshold);
        return this;
    }

    public SoftIndexFileStoreConfiguration create() {
        return new SoftIndexFileStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create());
    }

    public Builder<?> read(SoftIndexFileStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder self() {
        return this;
    }

    protected void validate(boolean skipClassChecks) {
        super.validate(skipClassChecks);
        int minNodeSize = (Integer)this.attributes.attribute(SoftIndexFileStoreConfiguration.MIN_NODE_SIZE).get();
        int maxNodeSize = (Integer)this.attributes.attribute(SoftIndexFileStoreConfiguration.MAX_NODE_SIZE).get();
        if (maxNodeSize <= 0 || maxNodeSize > Short.MAX_VALUE) {
            throw log.maxNodeSizeLimitedToShort(maxNodeSize);
        }
        if (minNodeSize < 0 || minNodeSize > maxNodeSize) {
            throw log.minNodeSizeMustBeLessOrEqualToMax(minNodeSize, maxNodeSize);
        }
        double compactionThreshold = (Double)this.attributes.attribute(SoftIndexFileStoreConfiguration.COMPACTION_THRESHOLD).get();
        if (compactionThreshold <= 0.0 || compactionThreshold > 1.0) {
            throw log.invalidCompactionThreshold(compactionThreshold);
        }
    }

    public String toString() {
        return "SoftIndexFileStoreConfigurationBuilder [attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }
}

