/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.Flowable;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexQueue;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.LogAppender;
import org.infinispan.persistence.sifs.LogRequest;
import org.infinispan.persistence.sifs.SyncProcessingQueue;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Store
public class SoftIndexFileStore
implements AdvancedLoadWriteStore {
    private static final Log log = (Log)LogFactory.getLog(SoftIndexFileStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private SoftIndexFileStoreConfiguration configuration;
    private boolean started = false;
    private TemporaryTable temporaryTable;
    private IndexQueue indexQueue;
    private SyncProcessingQueue<LogRequest> storeQueue;
    private FileProvider fileProvider;
    private LogAppender logAppender;
    private Index index;
    private Compactor compactor;
    private StreamingMarshaller marshaller;
    private ByteBufferFactory byteBufferFactory;
    private MarshallableEntryFactory marshallableEntryFactory;
    private TimeService timeService;
    private int maxKeyLength;

    public void init(InitializationContext ctx) {
        this.configuration = (SoftIndexFileStoreConfiguration)ctx.getConfiguration();
        this.marshaller = ctx.getMarshaller();
        this.marshallableEntryFactory = ctx.getMarshallableEntryFactory();
        this.byteBufferFactory = ctx.getByteBufferFactory();
        this.timeService = ctx.getTimeService();
        this.maxKeyLength = this.configuration.maxNodeSize() - IndexNode.RESERVED_SPACE;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("This store is already started!");
        }
        this.started = true;
        this.temporaryTable = new TemporaryTable(this.configuration.indexQueueLength() * this.configuration.indexSegments());
        this.storeQueue = new SyncProcessingQueue();
        this.indexQueue = new IndexQueue(this.configuration.indexSegments(), this.configuration.indexQueueLength());
        this.fileProvider = new FileProvider(this.configuration.dataLocation(), this.configuration.openFilesLimit());
        this.compactor = new Compactor(this.fileProvider, this.temporaryTable, this.indexQueue, (Marshaller)this.marshaller, this.timeService, this.configuration.maxFileSize(), this.configuration.compactionThreshold());
        this.logAppender = new LogAppender(this.storeQueue, this.indexQueue, this.temporaryTable, this.compactor, this.fileProvider, this.configuration.syncWrites(), this.configuration.maxFileSize());
        try {
            this.index = new Index(this.fileProvider, this.configuration.indexLocation(), this.configuration.indexSegments(), this.configuration.minNodeSize(), this.configuration.maxNodeSize(), this.indexQueue, this.temporaryTable, this.compactor, this.timeService);
        }
        catch (IOException e) {
            throw log.cannotOpenIndex(this.configuration.indexLocation(), e);
        }
        this.compactor.setIndex(this.index);
        this.startIndex();
        AtomicLong maxSeqId = new AtomicLong(0L);
        if (this.index.isLoaded()) {
            log.debug("Not building the index - loaded from persisted state");
        } else if (this.configuration.purgeOnStartup()) {
            log.debug("Not building the index - purge will be executed");
        } else {
            log.debug("Building the index");
            Flowable<Integer> filePublisher = this.filePublisher();
            this.handleFilePublisher((Flowable<Integer>)filePublisher.doAfterNext(this.compactor::completeFile), false, false, (file, offset, size, serializedKey, entryMetadata, serializedValue, seqId, expiration) -> {
                long prevSeqId;
                while (seqId > (prevSeqId = maxSeqId.get()) && !maxSeqId.compareAndSet(prevSeqId, seqId)) {
                }
                Object key = this.marshaller.objectFromByteBuffer(serializedKey);
                if (trace) {
                    log.tracef("Loaded %d:%d (seqId %d, expiration %d)", new Object[]{file, offset, seqId, expiration});
                }
                try {
                    if (this.isSeqIdOld(seqId, key, serializedKey)) {
                        this.indexQueue.put(IndexRequest.foundOld(key, serializedKey, file, offset));
                        return null;
                    }
                    this.temporaryTable.set(key, file, offset);
                    this.indexQueue.put(IndexRequest.update(key, serializedKey, file, offset, size));
                }
                catch (InterruptedException e) {
                    log.error("Interrupted building of index, the index won't be built properly!", e);
                    return null;
                }
                return null;
            }).blockingSubscribe();
        }
        this.logAppender.setSeqId(maxSeqId.get() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSeqIdOld(long seqId, Object key, byte[] serializedKey) throws IOException {
        EntryPosition entry;
        FileProvider.Handle handle;
        do {
            if ((entry = this.temporaryTable.get(key)) == null) {
                entry = this.index.getInfo(key, serializedKey);
            }
            if (entry != null) continue;
            if (trace) {
                log.tracef("Did not found position for %s", key);
            }
            return false;
        } while ((handle = this.fileProvider.getFile(entry.file)) == null);
        try {
            int entryOffset = entry.offset < 0 ? ~entry.offset : entry.offset;
            EntryHeader header = EntryRecord.readEntryHeader(handle, entryOffset);
            if (header == null) {
                throw new IOException("Cannot read " + entry.file + ":" + entryOffset);
            }
            if (trace) {
                log.tracef("SeqId on %d:%d is %d", entry.file, entry.offset, header.seqId());
            }
            boolean bl = seqId < header.seqId();
            return bl;
        }
        finally {
            handle.close();
        }
    }

    protected void startIndex() {
        this.index.start();
    }

    protected boolean isIndexLoaded() {
        return this.index.isLoaded();
    }

    public void stop() {
        try {
            this.logAppender.stopOperations();
            this.logAppender = null;
            this.compactor.stopOperations();
            this.compactor = null;
            this.index.stopOperations();
            this.index = null;
            this.fileProvider.stop();
            this.fileProvider = null;
            this.temporaryTable = null;
            this.indexQueue = null;
            this.storeQueue = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileStopping(e);
        }
        finally {
            this.started = false;
        }
    }

    public synchronized void destroy() {
        try {
            this.logAppender.stopOperations();
            this.logAppender = null;
            this.compactor.stopOperations();
            this.compactor = null;
            try {
                this.index.clear();
            }
            catch (IOException e) {
                log.debug("Couldn't clear index", e);
            }
            this.index.stopOperations();
            this.index = null;
            try {
                this.fileProvider.clear();
            }
            catch (IOException e) {
                log.debug("Couldn't clear fileProvider", e);
            }
            this.fileProvider = null;
            this.temporaryTable = null;
            this.indexQueue = null;
            this.storeQueue = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileStopping(e);
        }
        finally {
            this.started = false;
        }
    }

    public boolean isAvailable() {
        return new File(this.configuration.dataLocation()).exists() && new File(this.configuration.dataLocation()).exists();
    }

    public synchronized void clear() throws PersistenceException {
        try {
            this.logAppender.clearAndPause();
            this.compactor.clearAndPause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileClearing(e);
        }
        try {
            this.index.clear();
        }
        catch (IOException e) {
            throw log.cannotClearIndex(e);
        }
        try {
            this.fileProvider.clear();
        }
        catch (IOException e) {
            throw log.cannotClearData(e);
        }
        this.temporaryTable.clear();
        this.compactor.resumeAfterPause();
        this.logAppender.resumeAfterPause();
    }

    public synchronized int size() {
        try {
            this.logAppender.pause();
            long size = this.index.size();
            int n = size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.sizeCalculationInterrupted(e);
        }
        finally {
            this.logAppender.resumeAfterPause();
        }
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener listener) {
        log.trace("Purge method not supported, ignoring.");
    }

    public void write(MarshallableEntry entry) {
        int keyLength = entry.getKeyBytes().getLength();
        if (keyLength > this.maxKeyLength) {
            throw log.keyIsTooLong(entry.getKey(), keyLength, this.configuration.maxNodeSize(), this.maxKeyLength);
        }
        try {
            this.storeQueue.pushAndWait(LogRequest.storeRequest(entry));
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean delete(Object key) {
        try {
            LogRequest request = LogRequest.deleteRequest(key, this.toBuffer(this.marshaller.objectToByteBuffer(key)));
            this.storeQueue.pushAndWait(request);
            return (Boolean)request.getIndexRequest().getResult();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object key) {
        try {
            EntryPosition entry;
            while ((entry = this.temporaryTable.get(key)) != null) {
                if (entry.offset < 0) {
                    return false;
                }
                FileProvider.Handle handle = this.fileProvider.getFile(entry.file);
                if (handle == null) continue;
                try {
                    EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                    if (header == null) {
                        throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                    }
                    boolean bl = header.expiryTime() < 0L || header.expiryTime() > this.timeService.wallClockTime();
                    return bl;
                }
                finally {
                    handle.close();
                }
            }
            EntryPosition position = this.index.getPosition(key, this.marshaller.objectToByteBuffer(key));
            if (position == null) return false;
            return true;
        }
        catch (Exception e) {
            throw log.cannotLoadKeyFromIndex(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshallableEntry loadEntry(Object key) {
        try {
            EntryPosition entry;
            FileProvider.Handle handle;
            do {
                if ((entry = this.temporaryTable.get(key)) == null) {
                    EntryRecord record = this.index.getRecord(key, this.marshaller.objectToByteBuffer(key));
                    if (record != null) return this.marshallableEntryFactory.create(this.toBuffer(record.getKey()), this.toBuffer(record.getValue()), this.toBuffer(record.getMetadata()), record.getCreated(), record.getLastUsed());
                    return null;
                }
                if (entry.offset >= 0) continue;
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone", key, entry.file, entry.offset);
                return null;
            } while ((handle = this.fileProvider.getFile(entry.file)) == null);
            try {
                byte[] serializedValue;
                EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                if (header == null) {
                    throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                }
                if (header.expiryTime() > 0L && header.expiryTime() <= this.timeService.wallClockTime()) {
                    if (trace) {
                        log.tracef("Entry for key=%s found in temporary table on %d:%d but it is expired", key, entry.file, entry.offset);
                    }
                    MarshallableEntry marshallableEntry = null;
                    return marshallableEntry;
                }
                byte[] serializedKey = EntryRecord.readKey(handle, header, entry.offset);
                if (serializedKey == null) {
                    throw new IllegalStateException("Error reading key from " + entry.file + ":" + entry.offset);
                }
                EntryMetadata entryMetadata = header.metadataLength() > 0 ? EntryRecord.readMetadata(handle, header, entry.offset) : null;
                if (header.valueLength() > 0) {
                    serializedValue = EntryRecord.readValue(handle, header, entry.offset);
                    if (trace) {
                        log.tracef("Entry for key=%s found in temporary table on %d:%d and loaded", key, entry.file, entry.offset);
                    }
                } else {
                    if (trace) {
                        log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone in log", key, entry.file, entry.offset);
                    }
                    MarshallableEntry marshallableEntry = null;
                    return marshallableEntry;
                }
                if (entryMetadata == null) {
                    MarshallableEntry marshallableEntry = this.marshallableEntryFactory.create(this.toBuffer(serializedKey), this.toBuffer(serializedValue));
                    return marshallableEntry;
                }
                MarshallableEntry marshallableEntry = this.marshallableEntryFactory.create(this.toBuffer(serializedKey), this.toBuffer(serializedValue), this.toBuffer(entryMetadata.getBytes()), entryMetadata.getCreated(), entryMetadata.getLastUsed());
                return marshallableEntry;
            }
            finally {
                handle.close();
            }
        }
        catch (Exception e) {
            throw log.cannotLoadKeyFromIndex(key, e);
        }
    }

    public String debugInfo(Object key) {
        EntryPosition entry = this.temporaryTable.get(key);
        if (entry != null) {
            return "temporaryTable: " + entry;
        }
        try {
            entry = this.index.getPosition(key, this.marshaller.objectToByteBuffer(key));
            return "index: " + entry;
        }
        catch (Exception e) {
            log.debugf(e, "Cannot debug key %s", key);
            return "exception: " + e;
        }
    }

    private ByteBuffer toBuffer(byte[] array) {
        return array == null ? null : this.byteBufferFactory.newByteBuffer(array, 0, array.length);
    }

    private Flowable<Integer> filePublisher() {
        return Flowable.using(this.fileProvider::getFileIterator, it -> Flowable.fromIterable(() -> it), CloseableIterator::close);
    }

    private <R> Flowable<R> handleFilePublisher(Flowable<Integer> filePublisher, boolean fetchValue, boolean fetchMetadata, EntryFunctor<R> functor) {
        return filePublisher.flatMap(f -> {
            int file = f;
            return Flowable.using(() -> {
                log.debugf("Loading entries from file %d", file);
                return Optional.ofNullable(this.fileProvider.getFile(file));
            }, optHandle -> {
                if (!optHandle.isPresent()) {
                    log.debugf("File %d was deleted during iteration", file);
                    return Flowable.empty();
                }
                FileProvider.Handle handle = (FileProvider.Handle)optHandle.get();
                AtomicInteger offset = new AtomicInteger();
                return Flowable.fromIterable(() -> new HandleIterator(offset, handle, fetchMetadata, fetchValue, functor, file));
            }, optHandle -> {
                if (optHandle.isPresent()) {
                    ((FileProvider.Handle)optHandle.get()).close();
                }
            });
        });
    }

    public Publisher publishKeys(Predicate filter) {
        return this.handleFilePublisher(this.filePublisher(), false, true, (file, offset, size, serializedKey, entryMetadata, serializedValue, seqId, expiration) -> {
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (serializedValue != null && (filter == null || filter.test(key)) && !this.isSeqIdOld(seqId, key, serializedKey)) {
                return key;
            }
            return null;
        });
    }

    public Publisher<MarshallableEntry> entryPublisher(Predicate filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handleFilePublisher(this.filePublisher(), fetchValue, fetchMetadata, (file, offset, size, serializedKey, entryMetadata, serializedValue, seqId, expiration) -> {
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (serializedValue != null && (filter == null || filter.test(key)) && !this.isSeqIdOld(seqId, key, serializedKey)) {
                Object value;
                Object object = value = serializedValue == Util.EMPTY_BYTE_ARRAY ? null : this.marshaller.objectFromByteBuffer(serializedValue);
                if (entryMetadata == null) {
                    return this.marshallableEntryFactory.create(key, value);
                }
                Metadata metadata = (Metadata)this.marshaller.objectFromByteBuffer(entryMetadata.getBytes());
                return this.marshallableEntryFactory.create(key, value, metadata, entryMetadata.getCreated(), entryMetadata.getLastUsed());
            }
            return null;
        });
    }

    private class HandleIterator<R>
    extends AbstractIterator<R> {
        private final AtomicInteger offset;
        private final FileProvider.Handle handle;
        private final boolean fetchMetadata;
        private final boolean fetchValue;
        private final EntryFunctor<R> functor;
        private final int file;

        public HandleIterator(AtomicInteger offset, FileProvider.Handle handle, boolean fetchMetadata, boolean fetchValue, EntryFunctor<R> functor, int file) {
            this.offset = offset;
            this.handle = handle;
            this.fetchMetadata = fetchMetadata;
            this.fetchValue = fetchValue;
            this.functor = functor;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected R getNext() {
            R next = null;
            int innerOffset = this.offset.get();
            try {
                while (next == null) {
                    EntryHeader header = EntryRecord.readEntryHeader(this.handle, innerOffset);
                    if (header == null) {
                        return null;
                    }
                    try {
                        byte[] serializedKey = EntryRecord.readKey(this.handle, header, innerOffset);
                        if (serializedKey == null) continue;
                        EntryMetadata meta = null;
                        if (this.fetchMetadata && header.metadataLength() > 0) {
                            meta = EntryRecord.readMetadata(this.handle, header, innerOffset);
                        }
                        byte[] serializedValue = null;
                        int offsetOrNegation = innerOffset;
                        if (header.valueLength() > 0) {
                            if (header.expiryTime() >= 0L && header.expiryTime() <= SoftIndexFileStore.this.timeService.wallClockTime()) {
                                offsetOrNegation = ~innerOffset;
                            } else {
                                serializedValue = this.fetchValue ? EntryRecord.readValue(this.handle, header, innerOffset) : Util.EMPTY_BYTE_ARRAY;
                            }
                        } else {
                            offsetOrNegation = ~innerOffset;
                        }
                        next = this.functor.apply(this.file, offsetOrNegation, header.totalLength(), serializedKey, meta, serializedValue, header.seqId(), header.expiryTime());
                    }
                    finally {
                        innerOffset = this.offset.addAndGet(header.totalLength());
                    }
                }
                return next;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static interface EntryFunctor<R> {
        public R apply(int var1, int var2, int var3, byte[] var4, EntryMetadata var5, byte[] var6, long var7, long var9) throws Exception;
    }
}

