/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.util.logging.LogFactory;

public class FileProvider {
    private static final org.infinispan.persistence.sifs.Log log = (org.infinispan.persistence.sifs.Log)LogFactory.getLog(FileProvider.class, org.infinispan.persistence.sifs.Log.class);
    private final File dataDir;
    private final int openFileLimit;
    private final ArrayBlockingQueue<Record> recordQueue;
    private final ConcurrentMap<Integer, Record> openFiles = new ConcurrentHashMap<Integer, Record>();
    private final AtomicInteger currentOpenFiles = new AtomicInteger(0);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<Integer> logFiles = new HashSet<Integer>();
    private final Set<FileIterator> iterators = ConcurrentHashMap.newKeySet();
    private int nextFileId = 0;

    public FileProvider(String dataDir, int openFileLimit) {
        this.openFileLimit = openFileLimit;
        this.recordQueue = new ArrayBlockingQueue(openFileLimit);
        this.dataDir = new File(dataDir);
        this.dataDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handle getFile(int fileId) throws IOException {
        Handle handle;
        Record newRecord;
        int open;
        block25: {
            Record record;
            this.lock.readLock().lock();
            while ((record = (Record)this.openFiles.get(fileId)) != null) {
                Record record2 = record;
                synchronized (record2) {
                    if (record.isOpen()) {
                        Handle handle2 = new Handle(record);
                        return handle2;
                    }
                }
            }
            break block25;
            finally {
                this.lock.readLock().unlock();
            }
        }
        while (!((open = this.currentOpenFiles.get()) >= this.openFileLimit ? this.tryCloseFile() : this.currentOpenFiles.compareAndSet(open, open + 1))) {
        }
        while (true) {
            FileChannel fileChannel;
            try {
                fileChannel = this.openChannel(fileId);
            }
            catch (FileNotFoundException e) {
                this.currentOpenFiles.decrementAndGet();
                log.debugf(e, "File %d was not found", fileId);
                Handle handle3 = null;
                this.lock.readLock().unlock();
                return handle3;
            }
            newRecord = new Record(fileChannel, fileId);
            Record other = this.openFiles.putIfAbsent(fileId, newRecord);
            if (other == null) break;
            fileChannel.close();
            Record record = other;
            synchronized (record) {
                if (other.isOpen()) {
                    this.currentOpenFiles.decrementAndGet();
                    Handle handle4 = new Handle(other);
                    return handle4;
                }
            }
        }
        Object object = newRecord;
        synchronized (object) {
            if (!newRecord.isOpen()) {
                throw new IllegalStateException();
            }
            handle = new Handle(newRecord);
        }
        try {
            this.recordQueue.put(newRecord);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        object = handle;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize(int file) {
        this.lock.readLock().lock();
        try {
            if (this.logFiles.contains(file)) {
                long l = -1L;
                return l;
            }
            long l = new File(this.dataDir, String.valueOf(file)).length();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCloseFile() throws IOException {
        Record removed;
        try {
            removed = this.recordQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Record record = removed;
        synchronized (record) {
            if (removed.isUsed()) {
                try {
                    this.recordQueue.put(removed);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (removed.isOpen()) {
                    removed.close();
                    this.openFiles.remove(removed.getFileId(), removed);
                }
                return true;
            }
        }
        return false;
    }

    protected FileChannel openChannel(int fileId) throws FileNotFoundException {
        return new RandomAccessFile(new File(this.dataDir, String.valueOf(fileId)), "r").getChannel();
    }

    public Log getFileForLog() throws IOException {
        this.lock.writeLock().lock();
        try {
            while (true) {
                File f;
                if ((f = new File(this.dataDir, String.valueOf(this.nextFileId))).exists()) {
                    if (this.nextFileId == Integer.MAX_VALUE) {
                        this.nextFileId = 0;
                        continue;
                    }
                    ++this.nextFileId;
                    continue;
                }
                this.logFiles.add(this.nextFileId);
                for (FileIterator it : this.iterators) {
                    it.add(this.nextFileId);
                }
                Log log = new Log(this.nextFileId, new FileOutputStream(new File(this.dataDir, String.valueOf(this.nextFileId))).getChannel());
                return log;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<Integer> getFileIterator() {
        this.lock.readLock().lock();
        try {
            HashSet<Integer> set = new HashSet<Integer>();
            for (String file : this.dataDir.list()) {
                if (!file.matches("[0-9]*")) continue;
                set.add(Integer.parseInt(file));
            }
            FileIterator iterator = new FileIterator(set.iterator());
            this.iterators.add(iterator);
            FileIterator fileIterator = iterator;
            return fileIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() throws IOException {
        this.lock.writeLock().lock();
        log.debug("Dropping all data");
        while (!(this.currentOpenFiles.get() <= 0 || this.tryCloseFile() && this.currentOpenFiles.decrementAndGet() == 0)) {
        }
        if (!this.recordQueue.isEmpty()) {
            throw new IllegalStateException();
        }
        if (!this.openFiles.isEmpty()) {
            throw new IllegalStateException();
        }
        for (File file : this.dataDir.listFiles()) {
            if (file.delete()) continue;
            throw new IOException("Cannot delete file " + file);
        }
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteFile(int fileId) {
        this.lock.readLock().lock();
        try {
            while (true) {
                Record newRecord = new Record(null, fileId);
                Record record = this.openFiles.putIfAbsent(fileId, newRecord);
                if (record == null) {
                    newRecord.delete();
                    this.openFiles.remove(fileId, newRecord);
                    return;
                }
                Record record2 = record;
                synchronized (record2) {
                    if (this.openFiles.get(fileId) == record) {
                        try {
                            record.deleteOnClose();
                        }
                        catch (IOException e) {
                            log.cannotCloseDeleteFile(fileId, e);
                        }
                        return;
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void stop() {
        int open = this.currentOpenFiles.get();
        while (open > 0) {
            try {
                if (!this.tryCloseFile()) break;
                open = this.currentOpenFiles.decrementAndGet();
            }
            catch (IOException e) {
                log.cannotCloseFile(e);
            }
        }
        if (this.currentOpenFiles.get() != 0) {
            for (Map.Entry entry : this.openFiles.entrySet()) {
                log.debugf("File %d has %d open handles", (Integer)entry.getKey(), ((Record)entry.getValue()).handleCount);
            }
        }
    }

    private class FileIterator
    implements CloseableIterator {
        private final Iterator<Integer> diskFiles;
        private final ConcurrentLinkedQueue<Integer> addedFiles = new ConcurrentLinkedQueue();

        private FileIterator(Iterator<Integer> diskFiles) {
            this.diskFiles = diskFiles;
        }

        public void add(int file) {
            this.addedFiles.add(file);
        }

        public void close() {
            FileProvider.this.iterators.remove(this);
        }

        public boolean hasNext() {
            return this.diskFiles.hasNext() || !this.addedFiles.isEmpty();
        }

        public Object next() {
            return this.diskFiles.hasNext() ? this.diskFiles.next() : this.addedFiles.poll();
        }
    }

    private class Record {
        private final int fileId;
        private FileChannel fileChannel;
        private int handleCount;
        private boolean deleteOnClose = false;

        private Record(FileChannel fileChannel, int fileId) {
            this.fileChannel = fileChannel;
            this.fileId = fileId;
        }

        FileChannel getFileChannel() {
            return this.fileChannel;
        }

        void increaseHandleCount() {
            ++this.handleCount;
        }

        void decreaseHandleCount() throws IOException {
            --this.handleCount;
            if (this.handleCount == 0 && this.deleteOnClose) {
                this.fileChannel.close();
                this.fileChannel = null;
                FileProvider.this.openFiles.remove(this.fileId, this);
                this.delete();
            }
        }

        boolean isOpen() {
            return this.fileChannel != null;
        }

        boolean isUsed() {
            return this.handleCount > 0;
        }

        public int getFileId() {
            return this.fileId;
        }

        public void close() throws IOException {
            this.fileChannel.close();
            this.fileChannel = null;
            if (this.deleteOnClose) {
                this.delete();
            }
        }

        public void delete() {
            log.debug("Deleting file " + this.fileId);
            new File(FileProvider.this.dataDir, String.valueOf(this.fileId)).delete();
        }

        public void deleteOnClose() throws IOException {
            if (this.handleCount == 0) {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                FileProvider.this.openFiles.remove(this.fileId, this);
                this.delete();
            } else {
                log.debug("Marking file " + this.fileId + " for deletion");
                this.deleteOnClose = true;
            }
        }
    }

    public static final class Handle
    implements Closeable {
        private boolean usable = true;
        private Record record;

        private Handle(Record record) {
            this.record = record;
            record.increaseHandleCount();
        }

        public int read(ByteBuffer buffer, long offset) throws IOException {
            if (!this.usable) {
                throw new IllegalStateException();
            }
            return this.record.getFileChannel().read(buffer, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.usable = false;
            Record record = this.record;
            synchronized (record) {
                this.record.decreaseHandleCount();
            }
        }

        public long getFileSize() throws IOException {
            return this.record.fileChannel.size();
        }

        public int getFileId() {
            return this.record.getFileId();
        }
    }

    public final class Log
    implements Closeable {
        public final int fileId;
        public final FileChannel fileChannel;

        public Log(int fileId, FileChannel fileChannel) {
            this.fileId = fileId;
            this.fileChannel = fileChannel;
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
            FileProvider.this.lock.writeLock().lock();
            try {
                FileProvider.this.logFiles.remove(this.fileId);
            }
            finally {
                FileProvider.this.lock.writeLock().unlock();
            }
        }
    }
}

