/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.FileProvider;

public class EntryRecord {
    private EntryHeader header;
    private byte[] key;
    private byte[] value;
    private EntryMetadata meta;

    EntryRecord(EntryHeader header, byte[] key) {
        this.header = header;
        this.key = key;
    }

    public EntryHeader getHeader() {
        return this.header;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getMetadata() {
        return this.meta == null ? null : this.meta.getBytes();
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getCreated() {
        return this.meta == null ? -1L : this.meta.getCreated();
    }

    public long getLastUsed() {
        return this.meta == null ? -1L : this.meta.getLastUsed();
    }

    public EntryRecord loadMetadataAndValue(FileProvider.Handle handle, int offset) throws IOException {
        if (this.header.metadataLength() > 0) {
            this.meta = EntryRecord.readMetadata(handle, this.header, offset);
        }
        this.value = EntryRecord.readValue(handle, this.header, offset);
        return this;
    }

    public static EntryHeader readEntryHeader(FileProvider.Handle handle, long offset) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        if (EntryRecord.read(handle, header, offset, 24) < 0) {
            return null;
        }
        header.flip();
        try {
            return new EntryHeader(header);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error reading from " + handle.getFileId() + ":" + offset);
        }
    }

    public static byte[] readKey(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        byte[] key = new byte[header.keyLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(key), offset + 24L, header.keyLength()) < 0) {
            return null;
        }
        return key;
    }

    public static EntryMetadata readMetadata(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.metadataLength() > 0);
        offset += (long)(24 + header.keyLength());
        int metaLength = header.metadataLength() - 16;
        assert (metaLength > 0);
        byte[] metadata = new byte[metaLength];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(metadata), offset, metaLength) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(16);
        if (EntryRecord.read(handle, buffer, offset += (long)metaLength, 16) < 0) {
            throw new IllegalStateException("End of file reached when reading timestamps on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        buffer.flip();
        return new EntryMetadata(metadata, buffer.getLong(), buffer.getLong());
    }

    public static byte[] readValue(FileProvider.Handle handle, EntryHeader header, long offset) throws IOException {
        assert (header.valueLength() > 0);
        byte[] value = new byte[header.valueLength()];
        if (EntryRecord.read(handle, java.nio.ByteBuffer.wrap(value), offset + 24L + (long)header.keyLength() + (long)header.metadataLength(), header.valueLength()) < 0) {
            throw new IllegalStateException("End of file reached when reading metadata on " + handle.getFileId() + ":" + offset + ": " + header);
        }
        return value;
    }

    private static int read(FileProvider.Handle handle, java.nio.ByteBuffer buffer, long position, int length) throws IOException {
        int newRead;
        int read = 0;
        do {
            if ((newRead = handle.read(buffer, position + (long)read)) >= 0) continue;
            return -1;
        } while ((read += newRead) < length);
        return read;
    }

    public static void writeEntry(FileChannel fileChannel, byte[] serializedKey, EntryMetadata metadata, byte[] serializedValue, long seqId, long expiration) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        header.putShort((short)serializedKey.length);
        header.putShort(metadata == null ? (short)0 : (short)metadata.length());
        header.putInt(serializedValue == null ? 0 : serializedValue.length);
        header.putLong(seqId);
        header.putLong(expiration);
        header.flip();
        EntryRecord.write(fileChannel, header);
        EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedKey));
        if (metadata != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(metadata.getBytes()));
            EntryRecord.writeTimestamps(fileChannel, metadata.getCreated(), metadata.getLastUsed());
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedValue));
        }
    }

    public static void writeEntry(FileChannel fileChannel, ByteBuffer serializedKey, ByteBuffer serializedMetadata, ByteBuffer serializedValue, long seqId, long expiration, long created, long lastUsed) throws IOException {
        java.nio.ByteBuffer header = java.nio.ByteBuffer.allocate(24);
        header.putShort((short)serializedKey.getLength());
        header.putShort(EntryMetadata.size(serializedMetadata));
        header.putInt(serializedValue == null ? 0 : serializedValue.getLength());
        header.putLong(seqId);
        header.putLong(expiration);
        header.flip();
        EntryRecord.write(fileChannel, header);
        EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedKey.getBuf(), serializedKey.getOffset(), serializedKey.getLength()));
        if (serializedMetadata != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedMetadata.getBuf(), serializedMetadata.getOffset(), serializedMetadata.getLength()));
            EntryRecord.writeTimestamps(fileChannel, created, lastUsed);
        }
        if (serializedValue != null) {
            EntryRecord.write(fileChannel, java.nio.ByteBuffer.wrap(serializedValue.getBuf(), serializedValue.getOffset(), serializedValue.getLength()));
        }
    }

    private static void writeTimestamps(FileChannel fileChannel, long created, long lastUsed) throws IOException {
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(16);
        buffer.putLong(created);
        buffer.putLong(lastUsed);
        buffer.flip();
        EntryRecord.write(fileChannel, buffer);
    }

    private static void write(FileChannel fileChannel, java.nio.ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            fileChannel.write(buffer);
        }
    }
}

