/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexQueue;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.LogAppender;
import org.infinispan.persistence.sifs.LogRequest;
import org.infinispan.persistence.sifs.SyncProcessingQueue;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Store
public class SoftIndexFileStore
implements AdvancedLoadWriteStore<Object, Object> {
    private static final Log log = (Log)LogFactory.getLog(SoftIndexFileStore.class, Log.class);
    public static final String PREFIX_10_1 = "";
    public static final String PREFIX_11_0 = "ispn.";
    public static final String PREFIX_12_0 = "ispn12.";
    public static final String PREFIX_LATEST = "ispn12.";
    private SoftIndexFileStoreConfiguration configuration;
    private boolean started = false;
    private TemporaryTable temporaryTable;
    private IndexQueue indexQueue;
    private SyncProcessingQueue<LogRequest> storeQueue;
    private FileProvider fileProvider;
    private LogAppender logAppender;
    private Index index;
    private Compactor compactor;
    private Marshaller marshaller;
    private ByteBufferFactory byteBufferFactory;
    private MarshallableEntryFactory<Object, Object> marshallableEntryFactory;
    private TimeService timeService;
    private int maxKeyLength;
    private InitializationContext ctx;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SoftIndexFileStoreConfiguration)ctx.getConfiguration();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.marshallableEntryFactory = ctx.getMarshallableEntryFactory();
        this.byteBufferFactory = ctx.getByteBufferFactory();
        this.timeService = ctx.getTimeService();
        this.maxKeyLength = this.configuration.maxNodeSize() - IndexNode.RESERVED_SPACE;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("This store is already started!");
        }
        this.started = true;
        this.temporaryTable = new TemporaryTable(this.configuration.indexQueueLength() * this.configuration.indexSegments());
        this.storeQueue = new SyncProcessingQueue();
        this.indexQueue = new IndexQueue(this.configuration.indexSegments(), this.configuration.indexQueueLength());
        this.fileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), "ispn12.");
        this.compactor = new Compactor(this.fileProvider, this.temporaryTable, this.indexQueue, this.marshaller, this.timeService, this.configuration.maxFileSize(), this.configuration.compactionThreshold());
        this.logAppender = new LogAppender(this.storeQueue, this.indexQueue, this.temporaryTable, this.compactor, this.fileProvider, this.configuration.syncWrites(), this.configuration.maxFileSize());
        try {
            this.index = new Index(this.fileProvider, this.getIndexLocation(), this.configuration.indexSegments(), this.configuration.minNodeSize(), this.configuration.maxNodeSize(), this.indexQueue, this.temporaryTable, this.compactor, this.timeService);
        }
        catch (IOException e) {
            throw log.cannotOpenIndex(this.configuration.indexLocation(), e);
        }
        this.compactor.setIndex(this.index);
        this.startIndex();
        AtomicLong maxSeqId = new AtomicLong(0L);
        boolean migrateData = false;
        if (!this.configuration.purgeOnStartup()) {
            FileProvider oldFileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), PREFIX_10_1);
            if (oldFileProvider.hasFiles()) {
                throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationAcrossMajorVersions();
            }
            oldFileProvider = new FileProvider(this.getDataLocation(), this.configuration.openFilesLimit(), PREFIX_11_0);
            if (oldFileProvider.hasFiles()) {
                org.infinispan.util.logging.Log.PERSISTENCE.startMigratingPersistenceData();
                this.migrateFromOldFormat(oldFileProvider);
                migrateData = true;
            } else if (this.index.isLoaded()) {
                log.debug("Not building the index - loaded from persisted state");
            } else {
                log.debug("Building the index");
                this.buildIndex(maxSeqId);
            }
        } else {
            log.debug("Not building the index - purge will be executed");
        }
        if (!migrateData) {
            this.logAppender.setSeqId(maxSeqId.get() + 1L);
        }
    }

    private void migrateFromOldFormat(FileProvider oldFileProvider) {
        try {
            this.index.clear();
        }
        catch (IOException e) {
            throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed((Throwable)e);
        }
        boolean transformationRequired = this.ctx.getGlobalConfiguration().serialization().marshaller() == null;
        try (CloseableIterator<Integer> it = oldFileProvider.getFileIterator();){
            while (it.hasNext()) {
                int fileId = (Integer)it.next();
                try (FileProvider.Handle handle = oldFileProvider.getFile(fileId);){
                    EntryHeader header;
                    int offset = 0;
                    while ((header = EntryRecord.readEntryHeader(handle, offset)) != null) {
                        MarshallableEntry<Object, Object> entry = this.readEntry(handle, header, offset, null, true, (key, value, meta, internalMeta, created, lastUsed) -> {
                            if (!transformationRequired) {
                                return this.marshallableEntryFactory.create(key, value, meta, internalMeta, created, lastUsed);
                            }
                            try {
                                Object k = this.unmarshallLegacy(key, false);
                                Object v = this.unmarshallLegacy(value, false);
                                Metadata m = (Metadata)this.unmarshallLegacy(meta, true);
                                PrivateMetadata im = internalMeta == null ? null : (PrivateMetadata)this.ctx.getPersistenceMarshaller().objectFromByteBuffer(internalMeta.getBuf());
                                return this.marshallableEntryFactory.create(k, v, m, im, created, lastUsed);
                            }
                            catch (IOException | ClassNotFoundException e) {
                                throw new MarshallingException((Throwable)e);
                            }
                        });
                        if (entry.getValueBytes() != null) {
                            this.storeQueue.pushAndWait(LogRequest.storeRequest(entry));
                        } else {
                            this.storeQueue.pushAndWait(LogRequest.deleteRequest(entry.getKey(), entry.getKeyBytes()));
                        }
                        offset += header.totalLength();
                    }
                }
                oldFileProvider.deleteFile(fileId);
            }
            org.infinispan.util.logging.Log.PERSISTENCE.persistedDataSuccessfulMigrated();
        }
        catch (IOException | InterruptedException e) {
            throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed((Throwable)e);
        }
    }

    private <T> T unmarshallLegacy(ByteBuffer buf, boolean allowInternal) throws ClassNotFoundException, IOException {
        if (buf == null) {
            return null;
        }
        Marshaller marshaller = this.ctx.getPersistenceMarshaller().getUserMarshaller();
        try {
            return (T)marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
        }
        catch (IllegalArgumentException e) {
            if (allowInternal) {
                return (T)this.ctx.getPersistenceMarshaller().objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
            }
            throw e;
        }
    }

    private void buildIndex(AtomicLong maxSeqId) {
        Flowable<Integer> filePublisher = this.filePublisher();
        CompletionStage stage = this.handleFilePublisher((Flowable<Integer>)filePublisher.doAfterNext(this.compactor::completeFile), false, false, (file, offset, size, serializedKey, entryMetadata, serializedValue, serializedInternalMetadata, seqId, expiration) -> {
            long prevSeqId;
            while (seqId > (prevSeqId = maxSeqId.get()) && !maxSeqId.compareAndSet(prevSeqId, seqId)) {
            }
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (log.isTraceEnabled()) {
                log.tracef("Loaded %d:%d (seqId %d, expiration %d)", new Object[]{file, offset, seqId, expiration});
            }
            try {
                if (this.isSeqIdOld(seqId, key, serializedKey)) {
                    this.indexQueue.put(IndexRequest.foundOld(key, serializedKey, file, offset));
                    return null;
                }
                this.temporaryTable.set(key, file, offset);
                this.indexQueue.put(IndexRequest.update(key, serializedKey, file, offset, size));
            }
            catch (InterruptedException e) {
                log.error("Interrupted building of index, the index won't be built properly!", e);
                return null;
            }
            return null;
        }).ignoreElements().toCompletionStage(null);
        CompletionStages.join((CompletionStage)stage);
    }

    private Path getDataLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.dataLocation(), (String)this.ctx.getCache().getName(), (String)"data");
    }

    protected Path getIndexLocation() {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.indexLocation(), (String)this.ctx.getCache().getName(), (String)"index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSeqIdOld(long seqId, Object key, byte[] serializedKey) throws IOException {
        EntryPosition entry;
        FileProvider.Handle handle;
        do {
            if ((entry = this.temporaryTable.get(key)) == null) {
                entry = this.index.getInfo(key, serializedKey);
            }
            if (entry != null) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Did not found position for %s", key);
            }
            return false;
        } while ((handle = this.fileProvider.getFile(entry.file)) == null);
        try {
            int entryOffset = entry.offset < 0 ? ~entry.offset : entry.offset;
            EntryHeader header = EntryRecord.readEntryHeader(handle, entryOffset);
            if (header == null) {
                throw new IOException("Cannot read " + entry.file + ":" + entryOffset);
            }
            if (log.isTraceEnabled()) {
                log.tracef("SeqId on %d:%d is %d", entry.file, entry.offset, header.seqId());
            }
            boolean bl = seqId < header.seqId();
            return bl;
        }
        finally {
            handle.close();
        }
    }

    protected void startIndex() {
        this.index.start();
    }

    protected boolean isIndexLoaded() {
        return this.index.isLoaded();
    }

    public synchronized void stop() {
        try {
            this.logAppender.stopOperations();
            this.logAppender = null;
            this.compactor.stopOperations();
            this.compactor = null;
            this.index.stopOperations();
            this.index = null;
            this.fileProvider.stop();
            this.fileProvider = null;
            this.temporaryTable = null;
            this.indexQueue = null;
            this.storeQueue = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileStopping(e);
        }
        finally {
            this.started = false;
        }
    }

    public synchronized void destroy() {
        try {
            this.logAppender.stopOperations();
            this.logAppender = null;
            this.compactor.stopOperations();
            this.compactor = null;
            try {
                this.index.clear();
            }
            catch (IOException e) {
                log.debug("Couldn't clear index", e);
            }
            this.index.stopOperations();
            this.index = null;
            try {
                this.fileProvider.clear();
            }
            catch (IOException e) {
                log.debug("Couldn't clear fileProvider", e);
            }
            this.fileProvider = null;
            this.temporaryTable = null;
            this.indexQueue = null;
            this.storeQueue = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileStopping(e);
        }
        finally {
            this.started = false;
        }
    }

    public boolean isAvailable() {
        return new File(this.configuration.dataLocation()).exists() && new File(this.configuration.dataLocation()).exists();
    }

    public synchronized void clear() throws PersistenceException {
        try {
            this.logAppender.clearAndPause();
            this.compactor.clearAndPause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.interruptedWhileClearing(e);
        }
        try {
            this.index.clear();
        }
        catch (IOException e) {
            throw log.cannotClearIndex(e);
        }
        try {
            this.fileProvider.clear();
        }
        catch (IOException e) {
            throw log.cannotClearData(e);
        }
        this.temporaryTable.clear();
        this.compactor.resumeAfterPause();
        this.logAppender.resumeAfterPause();
    }

    public synchronized int size() {
        try {
            this.logAppender.pause();
            long size = this.index.size();
            int n = size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.sizeCalculationInterrupted(e);
        }
        finally {
            this.logAppender.resumeAfterPause();
        }
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener<? super Object> listener) {
        log.trace("Purge method not supported, ignoring.");
    }

    public void write(MarshallableEntry<?, ?> entry) {
        int keyLength = entry.getKeyBytes().getLength();
        if (keyLength > this.maxKeyLength) {
            throw log.keyIsTooLong(entry.getKey(), keyLength, this.configuration.maxNodeSize(), this.maxKeyLength);
        }
        try {
            this.storeQueue.pushAndWait(LogRequest.storeRequest(entry));
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean delete(Object key) {
        try {
            LogRequest request = LogRequest.deleteRequest(key, this.toBuffer(this.marshaller.objectToByteBuffer(key)));
            this.storeQueue.pushAndWait(request);
            return (Boolean)request.getIndexRequest().getResult();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object key) {
        try {
            EntryPosition entry;
            while ((entry = this.temporaryTable.get(key)) != null) {
                if (entry.offset < 0) {
                    return false;
                }
                FileProvider.Handle handle = this.fileProvider.getFile(entry.file);
                if (handle == null) continue;
                try {
                    EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                    if (header == null) {
                        throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                    }
                    boolean bl = header.expiryTime() < 0L || header.expiryTime() > this.timeService.wallClockTime();
                    return bl;
                }
                finally {
                    handle.close();
                }
            }
            EntryPosition position = this.index.getPosition(key, this.marshaller.objectToByteBuffer(key));
            if (position == null) return false;
            return true;
        }
        catch (Exception e) {
            throw log.cannotLoadKeyFromIndex(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshallableEntry<Object, Object> loadEntry(Object key) {
        try {
            EntryPosition entry;
            FileProvider.Handle handle;
            do {
                if ((entry = this.temporaryTable.get(key)) == null) {
                    EntryRecord record = this.index.getRecord(key, this.marshaller.objectToByteBuffer(key));
                    if (record != null) return this.marshallableEntryFactory.create(this.toBuffer(record.getKey()), this.toBuffer(record.getValue()), this.toBuffer(record.getMetadata()), this.toBuffer(record.getInternalMetadata()), record.getCreated(), record.getLastUsed());
                    return null;
                }
                if (entry.offset >= 0) continue;
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone", key, entry.file, entry.offset);
                return null;
            } while ((handle = this.fileProvider.getFile(entry.file)) == null);
            try {
                EntryHeader header = EntryRecord.readEntryHeader(handle, entry.offset);
                if (header == null) {
                    throw new IllegalStateException("Error reading from " + entry.file + ":" + entry.offset + " | " + handle.getFileSize());
                }
                MarshallableEntry<Object, Object> marshallableEntry = this.readEntry(handle, header, entry.offset, key, false, (serializedKey, value, meta, internalMeta, created, lastUsed) -> this.marshallableEntryFactory.create(serializedKey, value, meta, internalMeta, created, lastUsed));
                return marshallableEntry;
            }
            finally {
                handle.close();
            }
        }
        catch (Exception e) {
            throw log.cannotLoadKeyFromIndex(key, e);
        }
    }

    private MarshallableEntry<Object, Object> readEntry(FileProvider.Handle handle, EntryHeader header, int offset, Object key, boolean nonNull, EntryCreator<Object, Object> entryCreator) throws IOException {
        long lastUsed;
        long created;
        ByteBuffer serializedMetadata;
        if (header.expiryTime() > 0L && header.expiryTime() <= this.timeService.wallClockTime()) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is expired", key, handle.getFileId(), offset);
            }
            return nonNull ? entryCreator.create(this.readAndCheckKey(handle, header, offset), null, null, null, -1L, -1L) : null;
        }
        ByteBuffer serializedKey = this.readAndCheckKey(handle, header, offset);
        if (header.valueLength() <= 0) {
            if (log.isTraceEnabled()) {
                log.tracef("Entry for key=%s found in temporary table on %d:%d but it is a tombstone in log", key, handle.getFileId(), offset);
            }
            return nonNull ? entryCreator.create(serializedKey, null, null, null, -1L, -1L) : null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Entry for key=%s found in temporary table on %d:%d and loaded", key, handle.getFileId(), offset);
        }
        ByteBuffer value = this.toBuffer(EntryRecord.readValue(handle, header, offset));
        if (header.metadataLength() > 0) {
            EntryMetadata metadata = EntryRecord.readMetadata(handle, header, offset);
            serializedMetadata = this.toBuffer(metadata.getBytes());
            created = metadata.getCreated();
            lastUsed = metadata.getLastUsed();
        } else {
            serializedMetadata = null;
            created = -1L;
            lastUsed = -1L;
        }
        ByteBuffer internalMetadata = header.internalMetadataLength() > 0 ? this.toBuffer(EntryRecord.readInternalMetadata(handle, header, offset)) : null;
        return entryCreator.create(serializedKey, value, serializedMetadata, internalMetadata, created, lastUsed);
    }

    private ByteBuffer readAndCheckKey(FileProvider.Handle handle, EntryHeader header, int offset) throws IOException {
        ByteBuffer serializedKey = this.toBuffer(EntryRecord.readKey(handle, header, offset));
        if (serializedKey == null) {
            throw new IllegalStateException("Error reading key from " + handle.getFileId() + ":" + offset);
        }
        return serializedKey;
    }

    private ByteBuffer toBuffer(byte[] array) {
        return array == null ? null : this.byteBufferFactory.newByteBuffer(array, 0, array.length);
    }

    private Flowable<Integer> filePublisher() {
        return Flowable.using(this.fileProvider::getFileIterator, it -> Flowable.fromIterable(() -> it), CloseableIterator::close);
    }

    private <R> Flowable<R> handleFilePublisher(Flowable<Integer> filePublisher, boolean fetchValue, boolean fetchMetadata, EntryFunctor<R> functor) {
        return filePublisher.flatMap(f -> {
            int file = f;
            return Flowable.using(() -> {
                log.debugf("Loading entries from file %d", file);
                return Optional.ofNullable(this.fileProvider.getFile(file));
            }, optHandle -> {
                if (!optHandle.isPresent()) {
                    log.debugf("File %d was deleted during iteration", file);
                    return Flowable.empty();
                }
                FileProvider.Handle handle = (FileProvider.Handle)optHandle.get();
                AtomicInteger offset = new AtomicInteger();
                return Flowable.fromIterable(() -> new HandleIterator(offset, handle, fetchMetadata, fetchValue, functor, file));
            }, optHandle -> {
                if (optHandle.isPresent()) {
                    ((FileProvider.Handle)optHandle.get()).close();
                }
            });
        });
    }

    public Publisher<Object> publishKeys(Predicate<? super Object> filter) {
        return this.handleFilePublisher(this.filePublisher(), false, true, (file, offset, size, serializedKey, entryMetadata, serializedValue, serializedInternalMetadata, seqId, expiration) -> {
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (serializedValue != null && (filter == null || filter.test(key)) && !this.isSeqIdOld(seqId, key, serializedKey)) {
                return key;
            }
            return null;
        });
    }

    public Publisher<MarshallableEntry<Object, Object>> entryPublisher(Predicate<? super Object> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handleFilePublisher(this.filePublisher(), fetchValue, fetchMetadata, (file, offset, size, serializedKey, entryMetadata, serializedValue, serializedInternalMetadata, seqId, expiration) -> {
            Object key = this.marshaller.objectFromByteBuffer(serializedKey);
            if (serializedValue != null && (filter == null || filter.test(key)) && !this.isSeqIdOld(seqId, key, serializedKey)) {
                PrivateMetadata internalMetadata;
                Object value = serializedValue == Util.EMPTY_BYTE_ARRAY ? null : this.marshaller.objectFromByteBuffer(serializedValue);
                PrivateMetadata privateMetadata = internalMetadata = serializedInternalMetadata == null ? null : (PrivateMetadata)this.marshaller.objectFromByteBuffer(serializedInternalMetadata);
                if (entryMetadata == null) {
                    return this.marshallableEntryFactory.create(key, value, null, internalMetadata, -1L, -1L);
                }
                Metadata metadata = (Metadata)this.marshaller.objectFromByteBuffer(entryMetadata.getBytes());
                return this.marshallableEntryFactory.create(key, value, metadata, internalMetadata, entryMetadata.getCreated(), entryMetadata.getLastUsed());
            }
            return null;
        });
    }

    private class HandleIterator<R>
    extends AbstractIterator<R> {
        private final AtomicInteger offset;
        private final FileProvider.Handle handle;
        private final boolean fetchMetadata;
        private final boolean fetchValue;
        private final EntryFunctor<R> functor;
        private final int file;

        public HandleIterator(AtomicInteger offset, FileProvider.Handle handle, boolean fetchMetadata, boolean fetchValue, EntryFunctor<R> functor, int file) {
            this.offset = offset;
            this.handle = handle;
            this.fetchMetadata = fetchMetadata;
            this.fetchValue = fetchValue;
            this.functor = functor;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected R getNext() {
            R next = null;
            int innerOffset = this.offset.get();
            try {
                while (next == null) {
                    EntryHeader header = EntryRecord.readEntryHeader(this.handle, innerOffset);
                    if (header == null) {
                        return null;
                    }
                    try {
                        byte[] serializedKey = EntryRecord.readKey(this.handle, header, innerOffset);
                        if (serializedKey == null) continue;
                        EntryMetadata meta = null;
                        if (this.fetchMetadata && header.metadataLength() > 0) {
                            meta = EntryRecord.readMetadata(this.handle, header, innerOffset);
                        }
                        byte[] serializedValue = null;
                        int offsetOrNegation = innerOffset;
                        if (header.valueLength() > 0) {
                            if (header.expiryTime() >= 0L && header.expiryTime() <= SoftIndexFileStore.this.timeService.wallClockTime()) {
                                offsetOrNegation = ~innerOffset;
                            } else {
                                serializedValue = this.fetchValue ? EntryRecord.readValue(this.handle, header, innerOffset) : Util.EMPTY_BYTE_ARRAY;
                            }
                        } else {
                            offsetOrNegation = ~innerOffset;
                        }
                        byte[] serializedInternalMetadata = null;
                        if (this.fetchMetadata && header.internalMetadataLength() > 0) {
                            serializedInternalMetadata = EntryRecord.readInternalMetadata(this.handle, header, innerOffset);
                        }
                        next = this.functor.apply(this.file, offsetOrNegation, header.totalLength(), serializedKey, meta, serializedValue, serializedInternalMetadata, header.seqId(), header.expiryTime());
                    }
                    finally {
                        innerOffset = this.offset.addAndGet(header.totalLength());
                    }
                }
                return next;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static interface EntryFunctor<R> {
        public R apply(int var1, int var2, int var3, byte[] var4, EntryMetadata var5, byte[] var6, byte[] var7, long var8, long var10) throws Exception;
    }

    static interface EntryCreator<K, V> {
        public MarshallableEntry<K, V> create(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4, long var5, long var7) throws IOException;
    }
}

