/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    COMPACTION_THRESHOLD("compaction-threshold"),
    PATH("path"),
    INDEX_QUEUE_LENGTH("max-queue-length"),
    SEGMENTS("segments"),
    MAX_FILE_SIZE("max-file-size"),
    MAX_NODE_SIZE("max-node-size"),
    MIN_NODE_SIZE("min-node-size"),
    OPEN_FILES_LIMIT("open-files-limit"),
    SYNC_WRITES("sync-writes"),
    RELATIVE_TO("relative-to");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

