/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.concurrent.atomic.AtomicInteger;

class IndexRequest {
    private Type type = Type.UPDATE;
    private Object key;
    private int file;
    private int offset;
    private int prevFile = -1;
    private int prevOffset = -1;
    private byte[] serializedKey;
    private int size;
    private volatile Object result;
    private AtomicInteger countDown;

    public IndexRequest(Object key, byte[] serializedKey, int file, int offset, int size) {
        this.key = key;
        this.serializedKey = serializedKey;
        this.file = file;
        this.offset = offset;
        this.size = size;
    }

    public IndexRequest(Object key, byte[] serializedKey, int file, int offset, int size, int prevFile, int prevOffset) {
        this.key = key;
        this.serializedKey = serializedKey;
        this.file = file;
        this.offset = offset;
        this.size = size;
        this.prevFile = prevFile;
        this.prevOffset = prevOffset;
    }

    private IndexRequest(Type type) {
        this.type = type;
    }

    public static IndexRequest clearRequest() {
        return new IndexRequest(Type.CLEAR);
    }

    public static IndexRequest deleteFileRequest(int deletedFile) {
        IndexRequest req = new IndexRequest(Type.DELETE_FILE);
        req.file = deletedFile;
        return req;
    }

    public static IndexRequest stopRequest() {
        return new IndexRequest(Type.STOP);
    }

    public static IndexRequest sizeRequest() {
        return new IndexRequest(Type.GET_SIZE);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isCompareAndSet() {
        return this.prevFile != -1;
    }

    public Object getKey() {
        return this.key;
    }

    public long getPrevFile() {
        return this.prevFile;
    }

    public int getPrevOffset() {
        return this.prevOffset;
    }

    public byte[] getSerializedKey() {
        return this.serializedKey;
    }

    public synchronized void setResult(Object result) {
        if (this.result == null) {
            this.result = result;
        }
        this.notifyAll();
    }

    public synchronized Object getResult() throws InterruptedException {
        while (this.result == null) {
            this.wait();
        }
        return this.result;
    }

    public void setCountDown(int countDown) {
        this.countDown = new AtomicInteger(countDown);
    }

    public boolean countDown() {
        return this.countDown.decrementAndGet() == 0;
    }

    public int getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "IndexRequest{file=" + this.file + ", offset=" + this.offset + ", prevFile=" + this.prevFile + ", prevOffset=" + this.prevOffset + ", size=" + this.size + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        UPDATE,
        CLEAR,
        DELETE_FILE,
        STOP,
        GET_SIZE;

    }
}

