/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.ArrayDeque;

public class SyncProcessingQueue<T> {
    private final ArrayDeque<T> queue = new ArrayDeque();
    private final int maxPoppedInRow;
    private final Object sync = new Object();
    private volatile long popIndex = 0L;
    private long pushIndex = 0L;
    private long processorPopIndex = 0L;
    private int poppedInRow = 0;
    private volatile boolean error;

    public SyncProcessingQueue() {
        this(Integer.MAX_VALUE);
    }

    public SyncProcessingQueue(int maxPoppedInRow) {
        this.maxPoppedInRow = maxPoppedInRow;
    }

    public void pushAndWait(T element) throws InterruptedException {
        this.waitFor(this.push(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long push(T element) {
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            this.queue.push(element);
            this.queue.notify();
            ++this.pushIndex;
            return this.pushIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(long myIndex) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            while (myIndex > this.popIndex) {
                this.sync.wait();
            }
        }
        if (this.error) {
            throw new IllegalStateException("Exception in consumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T pop() {
        T element;
        if (this.poppedInRow >= this.maxPoppedInRow) {
            return null;
        }
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            element = this.queue.poll();
        }
        if (element == null) {
            return null;
        }
        ++this.processorPopIndex;
        ++this.poppedInRow;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAndWait() {
        this.poppedInRow = 0;
        this.popIndex = this.processorPopIndex;
        ArrayDeque<T> arrayDeque = this.sync;
        synchronized (arrayDeque) {
            this.sync.notifyAll();
        }
        arrayDeque = this.queue;
        synchronized (arrayDeque) {
            if (this.queue.isEmpty()) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNoWait() {
        this.poppedInRow = 0;
        this.popIndex = this.processorPopIndex;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.error = true;
        this.popIndex = Long.MAX_VALUE;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }
}

