/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.persistence.sifs.IndexRequest;

public class IndexQueue
extends AbstractQueue<IndexRequest>
implements BlockingQueue<IndexRequest> {
    private final ArrayBlockingQueue[] queues;
    private final Equivalence<Object> keyEquivalence;

    public IndexQueue(int segments, int capacity, Equivalence<Object> keyEquivalence) {
        this.queues = new ArrayBlockingQueue[segments];
        for (int i = 0; i < segments; ++i) {
            this.queues[i] = new ArrayBlockingQueue(capacity);
        }
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public Iterator<IndexRequest> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(IndexRequest indexRequest) throws InterruptedException {
        if (indexRequest.getKey() != null) {
            this.queues[Math.abs(this.keyEquivalence.hashCode(indexRequest.getKey())) % this.queues.length].put(indexRequest);
        } else {
            indexRequest.setCountDown(this.queues.length);
            for (int i = 0; i < this.queues.length; ++i) {
                this.queues[i].put(indexRequest);
            }
        }
    }

    @Override
    public boolean offer(IndexRequest indexRequest, long timeout, TimeUnit unit) throws InterruptedException {
        if (indexRequest.getKey() != null) {
            return this.queues[Math.abs(this.keyEquivalence.hashCode(indexRequest.getKey())) % this.queues.length].offer(indexRequest, timeout, unit);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexRequest take() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexRequest poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super IndexRequest> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super IndexRequest> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(IndexRequest indexRequest) {
        return this.queues[Math.abs(this.keyEquivalence.hashCode(indexRequest.getKey())) % this.queues.length].offer(indexRequest);
    }

    @Override
    public IndexRequest poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexRequest peek() {
        throw new UnsupportedOperationException();
    }

    public BlockingQueue<IndexRequest> subQueue(int id) {
        return this.queues[id];
    }
}

