/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TemporaryTable {
    private static Log log = LogFactory.getLog(TemporaryTable.class);
    private static boolean trace = log.isTraceEnabled();
    private ConcurrentMap<Object, Entry> table;

    public TemporaryTable(int capacity, Equivalence<Object> keyEquivalence) {
        this.table = CollectionFactory.makeConcurrentMap((int)capacity, keyEquivalence, (Equivalence)AnyEquivalence.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object key, int file, int offset) {
        Entry entry;
        while ((entry = this.table.putIfAbsent(key, new Entry(file, offset, false))) != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.isRemoved()) {
                    continue;
                }
                if (entry.isLocked()) {
                    try {
                        if (trace) {
                            log.tracef("Waiting for lock on %s", key);
                        }
                        entry.wait();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Unexpected interruption!", e);
                    }
                }
                entry.update(file, offset);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedEntry replaceOrLock(Object key, int file, int offset, int prevFile, int prevOffset) {
        Entry lockedEntry;
        Entry entry;
        while ((entry = this.table.putIfAbsent(key, lockedEntry = new Entry(-1, -1, true))) != null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.isRemoved()) {
                    continue;
                }
                if (entry.isLocked()) {
                    throw new IllegalStateException("Unexpected double locking");
                }
                if (entry.getFile() == prevFile && entry.getOffset() == prevOffset) {
                    entry.update(file, offset);
                }
                return null;
            }
        }
        return lockedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndUnlock(LockedEntry lockedEntry, int file, int offset) {
        Entry entry;
        Entry entry2 = entry = (Entry)lockedEntry;
        synchronized (entry2) {
            entry.file = file;
            entry.offset = offset;
            entry.locked = false;
            entry.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndUnlock(LockedEntry lockedEntry, Object key) {
        Entry entry;
        Entry entry2 = entry = (Entry)lockedEntry;
        synchronized (entry2) {
            this.table.remove(key);
            entry.setRemoved(true);
            entry.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition get(Object key) {
        Entry entry = (Entry)this.table.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            if (entry.isLocked()) {
                return null;
            }
            return new EntryPosition(entry.getFile(), entry.getOffset());
        }
    }

    public void clear() {
        this.table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConditionally(Object key, int file, int offset) {
        Entry tempEntry = (Entry)this.table.get(key);
        if (tempEntry != null) {
            Entry entry = tempEntry;
            synchronized (entry) {
                if (tempEntry.isLocked()) {
                    return;
                }
                if (tempEntry.getFile() == file && tempEntry.getOffset() == offset) {
                    this.table.remove(key, tempEntry);
                    tempEntry.setRemoved(true);
                }
            }
        }
    }

    public static abstract class LockedEntry {
        private LockedEntry() {
        }
    }

    private static class Entry
    extends LockedEntry {
        private int file;
        private int offset;
        private boolean locked;
        private boolean removed = false;

        Entry(int file, int offset, boolean locked) {
            this.file = file;
            this.offset = offset;
            this.locked = locked;
        }

        public int getFile() {
            return this.file;
        }

        public int getOffset() {
            return this.offset;
        }

        public void update(int currentFile, int currentOffset) {
            this.file = currentFile;
            this.offset = currentOffset;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }
}

