/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.sifs.IndexRequest;

class LogRequest {
    private final Type type;
    private final Object key;
    private final long expirationTime;
    private final ByteBuffer serializedKey;
    private final ByteBuffer serializedMetadata;
    private final ByteBuffer serializedValue;
    private boolean canContinue = false;
    private volatile IndexRequest indexRequest;

    private LogRequest(Type type, Object key, long expirationTime, ByteBuffer serializedKey, ByteBuffer serializedMetadata, ByteBuffer serializedValue) {
        this.key = key;
        this.expirationTime = expirationTime;
        this.serializedKey = serializedKey;
        this.serializedMetadata = serializedMetadata;
        this.serializedValue = serializedValue;
        this.type = type;
    }

    private LogRequest(Type type) {
        this(type, null, 0L, null, null, null);
    }

    public static LogRequest storeRequest(MarshalledEntry entry) {
        return new LogRequest(Type.STORE, entry.getKey(), entry.getMetadata() == null ? -1L : entry.getMetadata().expiryTime(), entry.getKeyBytes(), entry.getMetadataBytes(), entry.getValueBytes());
    }

    public static LogRequest deleteRequest(Object key, ByteBuffer serializedKey) {
        return new LogRequest(Type.DELETE, key, -1L, serializedKey, null, null);
    }

    public static LogRequest clearRequest() {
        return new LogRequest(Type.CLEAR_ALL);
    }

    public static LogRequest stopRequest() {
        return new LogRequest(Type.STOP);
    }

    public static LogRequest pauseRequest() {
        return new LogRequest(Type.PAUSE);
    }

    public int length() {
        return 24 + this.serializedKey.getLength() + (this.serializedValue != null ? this.serializedValue.getLength() : 0) + (this.serializedMetadata != null ? this.serializedMetadata.getLength() : 0);
    }

    public Object getKey() {
        return this.key;
    }

    public ByteBuffer getSerializedKey() {
        return this.serializedKey;
    }

    public ByteBuffer getSerializedMetadata() {
        return this.serializedMetadata;
    }

    public ByteBuffer getSerializedValue() {
        return this.serializedValue;
    }

    public long getExpiration() {
        return this.expirationTime;
    }

    public boolean isClear() {
        return this.type == Type.CLEAR_ALL;
    }

    public boolean isStop() {
        return this.type == Type.STOP;
    }

    public boolean isPause() {
        return this.type == Type.PAUSE;
    }

    public void setIndexRequest(IndexRequest indexRequest) {
        this.indexRequest = indexRequest;
    }

    public IndexRequest getIndexRequest() {
        return this.indexRequest;
    }

    public synchronized void pause() throws InterruptedException {
        while (!this.canContinue) {
            this.wait();
        }
    }

    public synchronized void resume() {
        this.canContinue = true;
        this.notify();
    }

    static enum Type {
        STORE,
        DELETE,
        CLEAR_ALL,
        STOP,
        PAUSE;

    }
}

