/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.embedded.deployment;

import com.github.benmanes.caffeine.cache.CacheLoader;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.cache.AbstractModuleConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.quarkus.embedded.deployment.InfinispanReflectionExcludedBuildItem;
import org.infinispan.quarkus.embedded.runtime.InfinispanEmbeddedProducer;
import org.infinispan.quarkus.embedded.runtime.InfinispanEmbeddedRuntimeConfig;
import org.infinispan.quarkus.embedded.runtime.InfinispanRecorder;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

class InfinispanEmbeddedProcessor {
    InfinispanEmbeddedProcessor() {
    }

    @BuildStep
    void addInfinispanDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.jgroups", "jgroups"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", "infinispan-commons"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", "infinispan-core"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", "infinispan-cachestore-jdbc-common"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", "infinispan-cachestore-jdbc"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", "infinispan-cachestore-sql"));
    }

    @BuildStep
    void setup(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<NativeImageResourceBuildItem> resources, CombinedIndexBuildItem combinedIndexBuildItem, List<InfinispanReflectionExcludedBuildItem> excludedReflectionClasses, ApplicationIndexBuildItem applicationIndexBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(InfinispanEmbeddedProducer.class));
        for (Class serviceLoadedInterface : Arrays.asList(ModuleMetadataBuilder.class, ConfigurationParser.class)) {
            ServiceLoader serviceLoader = ServiceLoader.load(serviceLoadedInterface);
            ArrayList interfaceImplementations = new ArrayList();
            serviceLoader.forEach(mmb -> interfaceImplementations.add(mmb.getClass().getName()));
            if (interfaceImplementations.isEmpty()) continue;
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(serviceLoadedInterface.getName(), interfaceImplementations));
        }
        HashSet<DotName> excludedClasses = new HashSet<DotName>();
        excludedReflectionClasses.forEach(excludedBuildItem -> excludedClasses.add(excludedBuildItem.getExcludedClass()));
        Index appOnlyIndex = applicationIndexBuildItem.getIndex();
        IndexView combinedIndex = combinedIndexBuildItem.getIndex();
        this.addReflectionForClass(CacheLoader.class, combinedIndex, reflectiveClass, excludedClasses);
        this.addReflectionForClass(CacheWriter.class, combinedIndex, reflectiveClass, excludedClasses);
        this.addReflectionForClass(NonBlockingStore.class, combinedIndex, reflectiveClass, excludedClasses);
        this.addReflectionForName(AsyncInterceptor.class.getName(), true, combinedIndex, reflectiveClass, false, true, excludedClasses);
        Collection listenerInstances = combinedIndex.getAnnotations(DotName.createSimple((String)Listener.class.getName()));
        for (AnnotationInstance instance : listenerInstances) {
            DotName targetName;
            AnnotationTarget target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS || excludedClasses.contains(targetName = target.asClass().name())) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{target.toString()}).methods().build());
        }
        this.addReflectionForClass(AdvancedExternalizer.class, (IndexView)appOnlyIndex, reflectiveClass, Collections.emptySet());
        this.addReflectionForClass(AbstractExternalizer.class, (IndexView)appOnlyIndex, reflectiveClass, Collections.emptySet());
        this.addReflectionForName("org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration", true, combinedIndex, reflectiveClass, true, false, excludedClasses);
        this.addReflectionForName("org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder", true, combinedIndex, reflectiveClass, true, false, excludedClasses);
        this.addReflectionForName("org.infinispan.persistence.jdbc.common.configuration.AbstractSchemaJdbcConfigurationBuilder", false, combinedIndex, reflectiveClass, true, false, excludedClasses);
        this.addReflectionForName("org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory", false, combinedIndex, reflectiveClass, false, false, excludedClasses);
        this.addReflectionForName("org.infinispan.persistence.keymappers.Key2StringMapper", true, combinedIndex, reflectiveClass, false, false, excludedClasses);
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"proto/generated/persistence.jdbc.proto"}));
        this.addReflectionForClass(StoreConfigurationBuilder.class, combinedIndex, reflectiveClass, excludedClasses);
        this.addReflectionForClass(StoreConfiguration.class, combinedIndex, reflectiveClass, true, excludedClasses);
        this.addReflectionForClass(ConfigurationSerializer.class, combinedIndex, reflectiveClass, excludedClasses);
        this.addReflectionForClass(AbstractModuleConfigurationBuilder.class, combinedIndex, reflectiveClass, excludedClasses);
    }

    private void addReflectionForClass(Class<?> classToUse, IndexView indexView, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, boolean methods, Set<DotName> excludedClasses) {
        this.addReflectionForName(classToUse.getName(), classToUse.isInterface(), indexView, reflectiveClass, methods, false, excludedClasses);
    }

    private void addReflectionForClass(Class<?> classToUse, IndexView indexView, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Set<DotName> excludedClasses) {
        this.addReflectionForClass(classToUse, indexView, reflectiveClass, false, excludedClasses);
    }

    private void addReflectionForName(String className, boolean isInterface, IndexView indexView, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, boolean methods, boolean fields, Set<DotName> excludedClasses) {
        Collection classInfos = isInterface ? indexView.getAllKnownImplementors(DotName.createSimple((String)className)) : indexView.getAllKnownSubclasses(DotName.createSimple((String)className));
        classInfos.removeIf(ci -> excludedClasses.contains(ci.name()));
        if (!classInfos.isEmpty()) {
            String[] classNames = (String[])classInfos.stream().map(ClassInfo::toString).toArray(String[]::new);
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames).methods(methods).fields(fields).build());
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimeProperties(InfinispanRecorder recorder, InfinispanEmbeddedRuntimeConfig runtimeConfig) {
        recorder.configureRuntimeProperties(runtimeConfig);
    }
}

