/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.server.deployment;

import com.thoughtworks.xstream.security.NoTypePermission;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ExcludeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ServiceLoader;
import org.infinispan.anchored.configuration.AnchoredKeysConfigurationBuilder;
import org.infinispan.commands.module.ModuleCommandExtensions;
import org.infinispan.commons.util.JVMMemoryInfoInfo;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.quarkus.embedded.deployment.InfinispanReflectionExcludedBuildItem;
import org.infinispan.rest.RestServer;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.tasks.Task;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.wildfly.security.password.impl.PasswordFactorySpiImpl;

class InfinispanServerProcessor {
    private static final String FEATURE_NAME = "infinispan-server";

    InfinispanServerProcessor() {
    }

    @BuildStep
    void setSystemProperties(BuildProducer<NativeImageSystemPropertyBuildItem> buildSystemProperties, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        buildSystemProperties.produce((BuildItem)new NativeImageSystemPropertyBuildItem("substratevm.replacement.jdksslcontext", "false"));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("infinispan.server.resource.logging", "false"));
    }

    @BuildStep
    void extensionFeatureStuff(BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<IndexDependencyBuildItem> indexedDependencies, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        feature.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE_NAME));
        for (String infinispanArtifact : Arrays.asList("infinispan-server-runtime", "infinispan-server-hotrod", "infinispan-server-core", "infinispan-server-rest", "infinispan-server-memcached", "infinispan-server-router", "infinispan-client-hotrod", "infinispan-cachestore-jdbc", "infinispan-cachestore-remote", "infinispan-clustered-counter", "infinispan-clustered-lock")) {
            indexedDependencies.produce((BuildItem)new IndexDependencyBuildItem("org.infinispan", infinispanArtifact));
        }
    }

    @BuildStep
    void loadServices(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        ServiceLoader<ModuleCommandExtensions> serviceLoader = ServiceLoader.load(ModuleCommandExtensions.class);
        ArrayList interfaceImplementations = new ArrayList();
        serviceLoader.forEach(mmb -> interfaceImplementations.add(mmb.getClass().getName()));
        if (!interfaceImplementations.isEmpty()) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(ModuleCommandExtensions.class.getName(), interfaceImplementations));
        }
    }

    @BuildStep
    void addExcludedClassesFromReflection(BuildProducer<InfinispanReflectionExcludedBuildItem> excludedClasses) {
        excludedClasses.produce((BuildItem)new InfinispanReflectionExcludedBuildItem(DotName.createSimple((String)"org.infinispan.persistence.remote.upgrade.MigrationTask$RemoveListener")));
    }

    @BuildStep
    void addRuntimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(CleartextHttp2ServerUpgradeHandler.class.getName()));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(Http2ServerUpgradeCodec.class.getName()));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(Resp3Handler.class.getName()));
    }

    @BuildStep
    void addReflectionAndResources(BuildProducer<ReflectiveClassBuildItem> reflectionClass, BuildProducer<NativeImageResourceBuildItem> resources, CombinedIndexBuildItem combinedIndexBuildItem) {
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{PrivateGlobalConfigurationBuilder.class.getName()}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ServerConfigurationBuilder.class.getName()}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{HotRodServer.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{MemcachedServer.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{RestServer.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{RespServer.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.apache.logging.log4j.message.ReusableMessageFactory"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.apache.logging.log4j.message.DefaultFlowMessageFactory"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{PasswordFactorySpiImpl.class}));
        IndexView combinedIndex = combinedIndexBuildItem.getIndex();
        this.addReflectionForClass(ProtocolServerConfigurationBuilder.class, false, combinedIndex, reflectionClass);
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{NoTypePermission.class.getName()}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"infinispan-defaults.xml", "proto/generated/persistence.counters.proto", "proto/generated/persistence.query.proto", "proto/generated/persistence.query.core.proto", "proto/generated/persistence.remote_query.proto", "proto/generated/persistence.memcached.proto", "proto/generated/persistence.resp.proto", "proto/generated/persistence.event_logger.proto", "proto/generated/persistence.multimap.proto", "proto/persistence.m.event_logger.proto", "proto/generated/persistence.server.core.proto", "proto/generated/persistence.servertasks.proto", "proto/generated/persistence.scripting.proto", "proto/generated/persistence.server_state.proto", "proto/generated/persistence.distribution.proto", "org/infinispan/query/remote/client/query.proto", "org/infinispan/protostream/message-wrapping.proto"}));
        this.registerClass(reflectionClass, JVMMemoryInfoInfo.class, true, false, false);
        this.registerClass(reflectionClass, MemoryType.class, true, false, true);
        this.registerClass(reflectionClass, MemoryUsage.class, true, false, true);
        this.registerClass(reflectionClass, CacheManagerInfo.class, true, false, false);
        this.addReflectionForName(Task.class.getName(), true, combinedIndex, reflectionClass, true, false);
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.health.impl.CacheHealthImpl"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.health.impl.ClusterHealthImpl"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.rest.resources.CacheManagerResource$HealthInfo"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.infinispan.rest.resources.CacheManagerResource$NamedCacheConfiguration"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.infinispan.rest.resources.CacheManagerResource$CacheInfo"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{"org.infinispan.rest.resources.ProtobufResource$ProtoSchema"}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{"org.infinispan.rest.resources.ProtobufResource$ValidationError"}));
        String[] elytronClasses = new String[]{"org.wildfly.security.http.digest.DigestMechanismFactory", "org.wildfly.security.http.basic.BasicMechanismFactory", "org.wildfly.security.password.impl.PasswordFactorySpiImpl", "org.wildfly.security.sasl.digest.DigestClientFactory", "org.wildfly.security.sasl.digest.DigestServerFactory", "org.wildfly.security.sasl.localuser.LocalUserClientFactory", "org.wildfly.security.sasl.localuser.LocalUserServerFactory", "org.wildfly.security.sasl.plain.PlainSaslClientFactory", "org.wildfly.security.sasl.plain.PlainSaslServerFactory", "org.wildfly.security.sasl.scram.ScramSaslClientFactory", "org.wildfly.security.sasl.scram.ScramSaslServerFactory", "org.wildfly.security.credential.KeyPairCredential", "org.wildfly.security.credential.PasswordCredential", "org.wildfly.security.credential.SecretKeyCredential", "org.wildfly.security.credential.X509CertificateChainPrivateCredential"};
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, elytronClasses));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{CounterManagerConfigurationBuilder.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{AnchoredKeysConfigurationBuilder.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{ClusteredLockManagerConfigurationBuilder.class}));
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new Class[]{RespServerConfigurationBuilder.class}));
    }

    @BuildStep
    void excludeResourcesFromDependencies(BuildProducer<ExcludeConfigBuildItem> excludeConfigBuildItemBuildProducer) {
        excludeConfigBuildItemBuildProducer.produce((BuildItem)new ExcludeConfigBuildItem("io\\.lettuce\\.lettuce-core-.+.jar", "/META-INF/native-image/io.lettuce/lettuce-core/reflect-config.json"));
    }

    private void addReflectionForClass(Class<?> classToUse, boolean isInterface, IndexView indexView, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        this.addReflectionForName(classToUse.getName(), isInterface, indexView, reflectiveClass, false, false);
    }

    private void addReflectionForName(String className, boolean isInterface, IndexView indexView, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, boolean methods, boolean fields) {
        Collection classInfos = isInterface ? indexView.getAllKnownImplementors(DotName.createSimple((String)className)) : indexView.getAllKnownSubclasses(DotName.createSimple((String)className));
        if (!classInfos.isEmpty()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, fields, (String[])classInfos.stream().map(ClassInfo::toString).toArray(String[]::new)));
        }
    }

    private void registerClass(BuildProducer<ReflectiveClassBuildItem> reflectionClass, Class<?> clazz, boolean methods, boolean fields, boolean ignoreNested) {
        reflectionClass.produce((BuildItem)new ReflectiveClassBuildItem(methods, fields, new Class[]{clazz}));
        if (!ignoreNested) {
            Class<?>[] declaredClasses;
            for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
                this.registerClass(reflectionClass, declaredClass, methods, fields, false);
            }
        }
    }
}

