package org.infinispan.query.dsl.impl.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-08-14T18:07:16+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String argumentCannotBeNull0$str() {
        return "ISPN014801: Argument cannot be null";
    }
    @Override
    public final IllegalArgumentException argumentCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentCannotBeNull0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String argumentMustBeComparable$str() {
        return "ISPN014802: '%s' must be an instance of java.lang.Comparable";
    }
    @Override
    public final IllegalArgumentException argumentMustBeComparable(final String argName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentMustBeComparable$str(), argName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterNameCannotBeNulOrEmpty$str() {
        return "ISPN014803: Parameter name cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException parameterNameCannotBeNulOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNameCannotBeNulOrEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryDoesNotHaveParameters$str() {
        return "ISPN014804: Query does not have parameters";
    }
    @Override
    public final IllegalStateException queryDoesNotHaveParameters() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryDoesNotHaveParameters$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterNotFound$str() {
        return "ISPN014805: No parameter named '%s' was found";
    }
    @Override
    public final IllegalArgumentException parameterNotFound(final String paramName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNotFound$str(), paramName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parametersNotFound$str() {
        return "ISPN014806: No parameters named '%s' were found";
    }
    @Override
    public final IllegalArgumentException parametersNotFound(final String unknownParams) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parametersNotFound$str(), unknownParams));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listOfValuesForInCannotBeNulOrEmpty$str() {
        return "ISPN014807: The list of values for 'in(..)' cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException listOfValuesForInCannotBeNulOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), listOfValuesForInCannotBeNulOrEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String operatorWasAlreadySpecified$str() {
        return "ISPN014808: operator was already specified";
    }
    @Override
    public final IllegalStateException operatorWasAlreadySpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operatorWasAlreadySpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conditionWasCreatedByAnotherFactory$str() {
        return "ISPN014809: The given condition was created by another factory";
    }
    @Override
    public final IllegalArgumentException conditionWasCreatedByAnotherFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), conditionWasCreatedByAnotherFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conditionIsAlreadyInUseByAnotherBuilder$str() {
        return "ISPN014810: The given condition is already in use by another builder";
    }
    @Override
    public final IllegalArgumentException conditionIsAlreadyInUseByAnotherBuilder() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), conditionIsAlreadyInUseByAnotherBuilder$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseOperatorAgain$str() {
        return "ISPN014811: Sentence already started. Cannot use '%s' again.";
    }
    @Override
    public final IllegalStateException cannotUseOperatorAgain(final String operatorName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotUseOperatorAgain$str(), operatorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String argumentCannotBeNull1$str() {
        return "ISPN014812: %s cannot be null";
    }
    @Override
    public final IllegalArgumentException argumentCannotBeNull(final String argName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentCannotBeNull1$str(), argName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryAlreadyBelongsToAnotherBuilder$str() {
        return "ISPN014813: This query already belongs to another query builder";
    }
    @Override
    public final IllegalStateException queryAlreadyBelongsToAnotherBuilder() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryAlreadyBelongsToAnotherBuilder$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String subQueryDoesNotBelongToAParentQueryBuilder$str() {
        return "ISPN014814: This sub-query does not belong to a parent query builder yet";
    }
    @Override
    public final IllegalStateException subQueryDoesNotBelongToAParentQueryBuilder() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), subQueryDoesNotBelongToAParentQueryBuilder$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupingCannotBeNullOrEmpty$str() {
        return "ISPN014815: Grouping cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException groupingCannotBeNullOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), groupingCannotBeNullOrEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupingCanBeSpecifiedOnlyOnce$str() {
        return "ISPN014816: Grouping can be specified only once";
    }
    @Override
    public final IllegalStateException groupingCanBeSpecifiedOnlyOnce() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), groupingCanBeSpecifiedOnlyOnce$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectingCollectionOrArray$str() {
        return "ISPN014817: Expecting a java.lang.Collection or an array of java.lang.Object";
    }
    @Override
    public final IllegalArgumentException expectingCollectionOrArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectingCollectionOrArray$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteSentence$str() {
        return "ISPN014818: Incomplete sentence. Missing attribute path or operator.";
    }
    @Override
    public final IllegalStateException incompleteSentence() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompleteSentence$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteCondition$str() {
        return "ISPN014819: Cannot visit an incomplete condition.";
    }
    @Override
    public final IllegalStateException incompleteCondition() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), incompleteCondition$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conditionNotFoundInParent$str() {
        return "ISPN014820: Old child condition not found in parent condition";
    }
    @Override
    public final IllegalStateException conditionNotFoundInParent() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), conditionNotFoundInParent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionCannotBeNullOrEmpty$str() {
        return "ISPN014821: Projection cannot be null or empty";
    }
    @Override
    public final IllegalArgumentException projectionCannotBeNullOrEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), projectionCannotBeNullOrEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionCanBeSpecifiedOnlyOnce$str() {
        return "ISPN014822: Projection can be specified only once";
    }
    @Override
    public final IllegalStateException projectionCanBeSpecifiedOnlyOnce() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), projectionCanBeSpecifiedOnlyOnce$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String maxResultMustBeGreaterThanZero$str() {
        return "ISPN014823: maxResults must be greater than 0";
    }
    @Override
    public final IllegalArgumentException maxResultMustBeGreaterThanZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), maxResultMustBeGreaterThanZero$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String startOffsetCannotBeLessThanZero$str() {
        return "ISPN014824: startOffset cannot be less than 0";
    }
    @Override
    public final IllegalArgumentException startOffsetCannotBeLessThanZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), startOffsetCannotBeLessThanZero$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryParameterNotSet$str() {
        return "ISPN014825: Query parameter '%s' was not set";
    }
    @Override
    public final IllegalStateException queryParameterNotSet(final String paramName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryParameterNotSet$str(), paramName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String leftAndRightCannotBeTheSame$str() {
        return "ISPN014826: Left and right condition cannot be the same";
    }
    @Override
    public final IllegalArgumentException leftAndRightCannotBeTheSame() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), leftAndRightCannotBeTheSame$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnPerfSortedNonIndexed(final String query) {
        super.log.logf(FQCN, WARN, null, warnPerfSortedNonIndexed$str(), query);
    }
    protected String warnPerfSortedNonIndexed$str() {
        return "ISPN014827: Distributed sort not supported for non-indexed query '%s'. Consider using an index for optimal performance.";
    }
}
