package org.infinispan.query.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.partitionhandling.AvailabilityException;
import javax.annotation.processing.Generated;
import org.infinispan.query.core.impl.Log;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.IntSet;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import jakarta.transaction.Transaction;
import org.jboss.logging.BasicLogger;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.search.mapper.common.EntityReference;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-09-24T16:35:19-0400")
public class Log_$logger extends DelegatingBasicLogger implements org.infinispan.query.logging.Log, Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String classNotIndexable$str() {
        return "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    }
    @Override
    public final CacheConfigurationException classNotIndexable(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), classNotIndexable$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void keyClassNotFound(final String keyClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, keyClassNotFound$str(), keyClassName);
    }
    protected String keyClassNotFound$str() {
        return "ISPN014001: Could not locate key class %s";
    }
    @Override
    public final void couldNotInstantiateTransformerClass(final Class<?> transformer, final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotInstantiateTransformerClass$str(), transformer);
    }
    protected String couldNotInstantiateTransformerClass$str() {
        return "ISPN014002: Cannot instantiate Transformer class %s";
    }
    @Override
    public final void registeringQueryInterceptor(final String cacheName) {
        super.log.logf(FQCN, INFO, null, registeringQueryInterceptor$str(), cacheName);
    }
    protected String registeringQueryInterceptor$str() {
        return "ISPN014003: Registering Query interceptor for cache %s";
    }
    @Override
    public final void commandsBackendInitialized(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, commandsBackendInitialized$str(), indexName);
    }
    protected String commandsBackendInitialized$str() {
        return "ISPN014004: Custom commands backend initialized backing index %s";
    }
    @Override
    public final void typeIsUsingDefaultTransformer(final Class<?> keyClass) {
        super.log.logf(FQCN, WARN, null, typeIsUsingDefaultTransformer$str(), keyClass);
    }
    protected String typeIsUsingDefaultTransformer$str() {
        return "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    }
    protected String cacheIsStoppingNoCommandAllowed$str() {
        return "ISPN014013: Cache named '%1$s' is being shut down. No longer accepting remote commands.";
    }
    @Override
    public final CacheException cacheIsStoppingNoCommandAllowed(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheIsStoppingNoCommandAllowed$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities, elapsedMs);
    }
    protected String indexingEntitiesCompleted$str() {
        return "ISPN014014: Reindexed %1$d entities in %2$d ms";
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, DEBUG, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    protected String indexingDocumentsCompleted$str() {
        return "ISPN014015: %1$d documents indexed in %2$d ms";
    }
    @Override
    public final void purgingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, purgingIndex$str(), entityType);
    }
    protected String purgingIndex$str() {
        return "ISPN014016: Purging instances of '%s' from the index";
    }
    @Override
    public final void flushingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, flushingIndex$str(), entityType);
    }
    protected String flushingIndex$str() {
        return "ISPN014017: Flushing index '%s'";
    }
    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    }
    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResumeSuspendedTx$str() {
        return "ISPN014033: Unable to resume suspended transaction %s";
    }
    @Override
    public final CacheException unableToResumeSuspendedTx(final Transaction transaction, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToResumeSuspendedTx$str(), transaction), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToSuspendTx$str() {
        return "ISPN014034: Unable to suspend transaction";
    }
    @Override
    public final CacheException unableToSuspendTx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToSuspendTx$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    }
    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(final String s) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupAggregationsNotSupported$str() {
        return "ISPN014039: Queries containing groups or aggregations cannot be converted to an indexed query";
    }
    @Override
    public final CacheException groupAggregationsNotSupported() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), groupAggregationsNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String filterNotSupportedWithQueryString$str() {
        return "ISPN014040: Unable to define filters, please use filters in the query string instead.";
    }
    @Override
    public final CacheException filterNotSupportedWithQueryString() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), filterNotSupportedWithQueryString$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTransformerForKey$str() {
        return "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    }
    @Override
    public final CacheException noTransformerForKey(final String keyClassName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTransformerForKey$str(), keyClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToParseSystemProperty(final String propertyName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToParseSystemProperty$str(), propertyName);
    }
    protected String failedToParseSystemProperty$str() {
        return "ISPN014044: Failed to parse system property %s";
    }
    @Override
    public final void settingBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount) {
        super.log.logf(FQCN, INFO, null, settingBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount);
    }
    protected String settingBooleanQueryMaxClauseCount$str() {
        return "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    }
    @Override
    public final void ignoringBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount, final int currentMaxClauseCount) {
        super.log.logf(FQCN, WARN, null, ignoringBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount, currentMaxClauseCount);
    }
    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    }
    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return "ISPN014050: Interrupted while waiting for completions of some batch indexing operations.";
    }
    @Override
    public final CacheException interruptedWhileWaitingForRequestCompletion(final Exception cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), interruptedWhileWaitingForRequestCompletion$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexingEntityFailures$str() {
        return "ISPN014051: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }
    @Override
    public final SearchException massIndexingEntityFailures(final long finalFailureCount, final EntityReference firstFailureEntity, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexerIndexingInstance$str() {
        return "ISPN014052: Indexing instance of entity '%s' during mass indexing";
    }
    @Override
    public final String massIndexerIndexingInstance(final String entityName) {
        return String.format(getLoggingLocale(), massIndexerIndexingInstance$str(), entityName);
    }
    protected String invalidPropertyKey$str() {
        return "ISPN014053: Invalid property key '%1$s`, it's not a string.";
    }
    @Override
    public final CacheException invalidPropertyKey(final Object propertyKey) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), invalidPropertyKey$str(), propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTypeIsIndexed$str() {
        return "ISPN014054: Trying to execute query `%1$s`, but no type is indexed on cache.";
    }
    @Override
    public final CacheException noTypeIsIndexed(final String ickle) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTypeIsIndexed$str(), ickle));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchMappingUnavailable$str() {
        return "ISPN014055: Cannot index entry since the search mapping failed to initialize.";
    }
    @Override
    public final CacheException searchMappingUnavailable() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), searchMappingUnavailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void mappingIsRestarting() {
        super.log.logf(FQCN, WARN, null, mappingIsRestarting$str());
    }
    protected String mappingIsRestarting$str() {
        return "ISPN014059: The indexing engine is restarting, index updates will be skipped for the current data changes.";
    }
    @Override
    public final void concurrentReindexingOnGetStatistics(final Throwable cause) {
        super.log.logf(FQCN, INFO, cause, concurrentReindexingOnGetStatistics$str());
    }
    protected String concurrentReindexingOnGetStatistics$str() {
        return "ISPN014060: We're getting some errors from Hibernate Search or Lucene while we compute the index count/size for statistics. There is probably a concurrent reindexing ongoing.";
    }
    protected String cannotLoadIndexedClass$str() {
        return "ISPN014061: Failed to load declared indexed class '%s'";
    }
    @Override
    public final CacheConfigurationException cannotLoadIndexedClass(final String name, final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotLoadIndexedClass$str(), name), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void preIndexingReloading() {
        super.log.logf(FQCN, DEBUG, null, preIndexingReloading$str());
    }
    protected String preIndexingReloading$str() {
        return "ISPN014062: Search engine is reloaded before the reindexing.";
    }
    @Override
    public final void indexingStarting() {
        super.log.logf(FQCN, INFO, null, indexingStarting$str());
    }
    protected String indexingStarting$str() {
        return "ISPN014063: Reindexing starting.";
    }
    protected String multipleKnnPredicates$str() {
        return "ISPN014064: Multiple knn predicates are not supported at the moment.";
    }
    @Override
    public final ParsingException multipleKnnPredicates() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multipleKnnPredicates$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String booleanKnnPredicates$str() {
        return "ISPN014065: Boolean predicates containing knn predicates are not supported at the moment.";
    }
    @Override
    public final ParsingException booleanKnnPredicates() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), booleanKnnPredicates$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToPurgeIndexForSegments(final Throwable cause, final IntSet removedSegments) {
        super.log.logf(FQCN, WARN, cause, failedToPurgeIndexForSegments$str(), removedSegments);
    }
    protected String failedToPurgeIndexForSegments$str() {
        return "ISPN014066: Failed to purge index for segments %s";
    }
    protected String groupingAndAggregationQueriesMustUseProjections$str() {
        return "ISPN014021: Queries containing grouping and aggregation functions must use projections.";
    }
    @Override
    public final ParsingException groupingAndAggregationQueriesMustUseProjections() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), groupingAndAggregationQueriesMustUseProjections$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHaveAggregationsInGroupByClause$str() {
        return "ISPN014022: Cannot have aggregate functions in GROUP BY clause";
    }
    @Override
    public final IllegalStateException cannotHaveAggregationsInGroupByClause() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotHaveAggregationsInGroupByClause$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multivaluedPropertyCannotBeUsedInGroupBy$str() {
        return "ISPN014023: Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported";
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInGroupBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInGroupBy$str(), propertyPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multivaluedPropertyCannotBeUsedInOrderBy$str() {
        return "ISPN014024: The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued";
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInOrderBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInOrderBy$str(), propertyPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryMustNotUseGroupingOrAggregation$str() {
        return "ISPN014025: The query must not use grouping or aggregation";
    }
    @Override
    public final IllegalStateException queryMustNotUseGroupingOrAggregation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryMustNotUseGroupingOrAggregation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str() {
        return "ISPN014026: The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause";
    }
    @Override
    public final ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str(), propertyPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multivaluedPropertyCannotBeProjected$str() {
        return "ISPN014027: The property path '%s' cannot be projected because it is multi-valued";
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeProjected(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeProjected$str(), propertyPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String partitionDegraded$str() {
        return "ISPN014042: Cannot execute query: cluster is operating in degraded mode and partition handling configuration doesn't allow reads and writes.";
    }
    @Override
    public final AvailabilityException partitionDegraded() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), partitionDegraded$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedStatement$str() {
        return "ISPN014056: Only DELETE statements are supported by executeStatement";
    }
    @Override
    public final CacheException unsupportedStatement() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unsupportedStatement$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteStatementsCannotUsePaging$str() {
        return "ISPN014057: DELETE statements cannot use paging (firstResult/maxResults)";
    }
    @Override
    public final CacheException deleteStatementsCannotUsePaging() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), deleteStatementsCannotUsePaging$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String entryIteratorDoesNotAllowProjections$str() {
        return "ISPN014058: Projections are not supported with entryIterator()";
    }
    @Override
    public final CacheException entryIteratorDoesNotAllowProjections() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), entryIteratorDoesNotAllowProjections$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
