/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.encoding.DataConversion;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.remoting.transport.Address;

class DistributedIterator<T>
implements CloseableIterator<T> {
    private final AdvancedCache<?, ?> cache;
    private final DataConversion keyDataConversion;
    private int currentIndex = -1;
    private final int fetchSize;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;
    private final NodeTopDocs[] partialResults;
    private final int[] partialPositionNext;
    private final TopDocs mergedResults;
    private final LocalQueryStatistics queryStatistics;

    DistributedIterator(LocalQueryStatistics queryStatistics, Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, Map<Address, NodeTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.queryStatistics = queryStatistics;
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        this.keyDataConversion = cache.getKeyDataConversion();
        int parallels = topDocsResponses.size();
        this.partialResults = new NodeTopDocs[parallels];
        boolean isFieldDocs = this.expectTopFieldDocs(topDocsResponses);
        TopFieldDocs[] partialTopDocs = isFieldDocs ? new TopFieldDocs[parallels] : new TopDocs[parallels];
        this.partialPositionNext = new int[parallels];
        int i = 0;
        for (Map.Entry<Address, NodeTopDocs> entry : topDocsResponses.entrySet()) {
            this.partialResults[i] = entry.getValue();
            partialTopDocs[i] = this.partialResults[i].topDocs;
            ++i;
        }
        this.mergedResults = isFieldDocs ? TopDocs.merge((Sort)sort, (int)firstResult, (int)maxResults, (TopFieldDocs[])partialTopDocs, (boolean)true) : TopDocs.merge((int)firstResult, (int)maxResults, (TopDocs[])partialTopDocs, (boolean)true);
    }

    private boolean expectTopFieldDocs(Map<Address, NodeTopDocs> topDocsResponses) {
        Iterator<NodeTopDocs> it = topDocsResponses.values().iterator();
        if (it.hasNext()) {
            return it.next().topDocs instanceof TopFieldDocs;
        }
        return false;
    }

    public void close() {
    }

    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        ScoreDoc scoreDoc = this.mergedResults.scoreDocs[this.currentIndex];
        int index = scoreDoc.shardIndex;
        NodeTopDocs nodeTopDocs = this.partialResults[index];
        if (this.partialPositionNext[index] == 0) {
            int docId = scoreDoc.doc;
            ScoreDoc[] scoreDocs = nodeTopDocs.topDocs.scoreDocs;
            for (int i = 0; i < scoreDocs.length; ++i) {
                if (scoreDocs[i].doc != docId) continue;
                this.partialPositionNext[index] = i;
                break;
            }
        }
        int n = index;
        int n2 = this.partialPositionNext[n];
        this.partialPositionNext[n] = n2 + 1;
        int pos = n2;
        Object[] keys = nodeTopDocs.keys;
        if (keys == null || keys.length == 0) {
            return (T)nodeTopDocs.projections[pos];
        }
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        Object key = this.keyDataConversion.fromStorage(keys[pos]);
        Object value = this.cache.get(key);
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.entityLoaded(System.nanoTime() - start);
        }
        return this.decorate(key, value);
    }

    protected T decorate(Object key, Object value) {
        return (T)value;
    }

    public final boolean hasNext() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }
}

