/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.io.IOException;
import java.util.UUID;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.QueryBox;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.QueryDefinition;

abstract class CQWorker {
    protected AdvancedCache<?, ?> cache;
    private KeyTransformationHandler keyTransformationHandler;
    private QueryBox queryBox;
    private SearchIntegrator searchFactory;
    protected QueryDefinition queryDefinition;
    protected UUID queryId;
    protected int docIndex;

    CQWorker() {
    }

    void initialize(AdvancedCache<?, ?> cache, QueryDefinition queryDefinition, UUID queryId, int docIndex) {
        this.cache = cache;
        this.keyTransformationHandler = ComponentRegistryUtils.getQueryInterceptor(cache).getKeyTransformationHandler();
        if (queryDefinition != null) {
            this.queryDefinition = queryDefinition;
            this.queryDefinition.initialize(cache);
        }
        this.queryId = queryId;
        this.docIndex = docIndex;
    }

    abstract QueryResponse perform();

    QueryBox getQueryBox() {
        if (this.queryBox == null) {
            this.queryBox = (QueryBox)this.cache.getComponentRegistry().getComponent(QueryBox.class);
        }
        return this.queryBox;
    }

    SearchIntegrator getSearchFactory() {
        if (this.searchFactory == null) {
            this.searchFactory = (SearchIntegrator)this.cache.getComponentRegistry().getComponent(SearchIntegrator.class);
        }
        return this.searchFactory;
    }

    Object extractKey(DocumentExtractor extractor, int docIndex) {
        String strKey;
        try {
            strKey = (String)((Object)extractor.extract(docIndex).getId());
        }
        catch (IOException e) {
            throw new SearchException("Error while extracting key", (Throwable)e);
        }
        return this.keyTransformationHandler.stringToKey(strKey);
    }
}

