/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.query.Transformable;
import org.infinispan.query.Transformer;
import org.infinispan.query.impl.DefaultTransformer;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class KeyTransformationHandler {
    private static final Log log = (Log)LogFactory.getLog(KeyTransformationHandler.class, Log.class);
    private final Map<Class<?>, Class<? extends Transformer>> transformerTypes = new ConcurrentHashMap();
    private final ClassLoader classLoader;

    public KeyTransformationHandler(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object stringToKey(String s) {
        char type = s.charAt(0);
        switch (type) {
            case 'S': {
                return s.substring(2);
            }
            case 'I': {
                return Integer.valueOf(s.substring(2));
            }
            case 'Y': {
                return Byte.valueOf(s.substring(2));
            }
            case 'L': {
                return Long.valueOf(s.substring(2));
            }
            case 'X': {
                return Short.valueOf(s.substring(2));
            }
            case 'D': {
                return Double.valueOf(s.substring(2));
            }
            case 'F': {
                return Float.valueOf(s.substring(2));
            }
            case 'B': {
                return Boolean.valueOf(s.substring(2));
            }
            case 'C': {
                return Character.valueOf(s.charAt(2));
            }
            case 'U': {
                return UUID.fromString(s.substring(2));
            }
            case 'A': {
                return Base64.getDecoder().decode(s.substring(2));
            }
            case 'T': {
                int indexOfSecondDelimiter = s.indexOf(58, 2);
                String keyClassName = s.substring(2, indexOfSecondDelimiter);
                String keyAsString = s.substring(indexOfSecondDelimiter + 1);
                Transformer t = this.getTransformer(keyClassName);
                if (t != null) {
                    return t.fromString(keyAsString);
                }
                throw log.noTransformerForKey(keyClassName);
            }
        }
        throw new CacheException("Unknown key type metadata: " + type);
    }

    private Transformer getTransformer(String keyClassName) {
        Class keyClass;
        try {
            keyClass = Util.loadClassStrict((String)keyClassName, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            log.keyClassNotFound(keyClassName, e);
            return null;
        }
        return this.getTransformer(keyClass);
    }

    public String keyToString(Object key) {
        if (key instanceof byte[]) {
            return "A:" + Base64.getEncoder().encodeToString((byte[])key);
        }
        if (key instanceof String) {
            return "S:" + key;
        }
        if (key instanceof Integer) {
            return "I:" + key;
        }
        if (key instanceof Boolean) {
            return "B:" + key;
        }
        if (key instanceof Long) {
            return "L:" + key;
        }
        if (key instanceof Float) {
            return "F:" + key;
        }
        if (key instanceof Double) {
            return "D:" + key;
        }
        if (key instanceof Short) {
            return "X:" + key;
        }
        if (key instanceof Byte) {
            return "Y:" + key;
        }
        if (key instanceof Character) {
            return "C:" + key;
        }
        if (key instanceof UUID) {
            return "U:" + key;
        }
        Transformer t = this.getTransformer(key.getClass());
        if (t != null) {
            return "T:" + key.getClass().getName() + ":" + t.toString(key);
        }
        throw log.noTransformerForKey(key.getClass().getName());
    }

    private Transformer getTransformer(Class<?> keyClass) {
        Class<? extends Transformer> transformerClass = this.getTransformerClass(keyClass);
        if (transformerClass != null) {
            try {
                return transformerClass.newInstance();
            }
            catch (Exception e) {
                log.couldNotInstantiaterTransformerClass(transformerClass, e);
            }
        }
        return null;
    }

    private Class<? extends Transformer> getTransformerClass(Class<?> keyClass) {
        Class<? extends Transformer> transformerClass = this.transformerTypes.get(keyClass);
        if (transformerClass == null) {
            Transformable transformableAnnotation = keyClass.getAnnotation(Transformable.class);
            Class<? extends Transformer> clazz = transformerClass = transformableAnnotation != null ? transformableAnnotation.transformer() : null;
            if (transformerClass != null) {
                if (transformerClass == DefaultTransformer.class) {
                    log.typeIsUsingDefaultTransformer(keyClass);
                }
                this.registerTransformer(keyClass, transformerClass);
            }
        }
        return transformerClass;
    }

    public void registerTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.transformerTypes.put(keyClass, transformerClass);
    }
}

