/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.encoding.DataConversion;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.SecurityActions;

public final class IndexWorker
implements Function<EmbeddedCacheManager, Void> {
    private final String cacheName;
    private final IndexedTypeIdentifier indexedType;
    private final boolean flush;
    private final boolean clean;
    private final boolean primaryOwner;
    private final Set<Object> keys;

    IndexWorker(String cacheName, IndexedTypeIdentifier indexedType, boolean flush, boolean clean, boolean primaryOwner, Set<Object> keys) {
        this.cacheName = cacheName;
        this.indexedType = indexedType;
        this.flush = flush;
        this.clean = clean;
        this.primaryOwner = primaryOwner;
        this.keys = keys;
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        Cache cache = embeddedCacheManager.getCache(this.cacheName);
        AdvancedCache unwrapped = SecurityActions.getUnwrappedCache(cache).getAdvancedCache();
        if (unwrapped.getCacheConfiguration().memory().storageType() == StorageType.OBJECT) {
            cache = unwrapped.withWrapping(ByteArrayWrapper.class, IdentityWrapper.class);
        }
        SearchIntegrator searchIntegrator = ComponentRegistryUtils.getSearchIntegrator(unwrapped);
        KeyTransformationHandler keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(unwrapped);
        TimeService timeService = ComponentRegistryUtils.getTimeService(unwrapped);
        IndexUpdater indexUpdater = new IndexUpdater(searchIntegrator, keyTransformationHandler, timeService);
        ClusteringDependentLogic clusteringDependentLogic = SecurityActions.getClusteringDependentLogic(unwrapped);
        DataConversion keyDataConversion = unwrapped.getKeyDataConversion();
        DataConversion valueDataConversion = unwrapped.getValueDataConversion();
        if (this.keys == null || this.keys.size() == 0) {
            this.preIndex(indexUpdater);
            KeyValueFilter filter = this.getFilter(clusteringDependentLogic, keyDataConversion);
            try (CacheStream stream = cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).cacheEntrySet().stream();){
                Iterator iterator = stream.filter(CacheFilters.predicate((KeyValueFilter)filter)).iterator();
                while (iterator.hasNext()) {
                    CacheEntry next = (CacheEntry)iterator.next();
                    Object value = this.extractValue(next.getValue(), valueDataConversion);
                    if (value == null || !value.getClass().equals(this.indexedType.getPojoType())) continue;
                    indexUpdater.updateIndex(next.getKey(), value);
                }
            }
            this.postIndex(indexUpdater);
        } else {
            HashSet classSet = new HashSet();
            for (Object object : this.keys) {
                Object value = this.extractValue(cache.get(object), valueDataConversion);
                if (value == null) continue;
                indexUpdater.updateIndex(object, value);
                classSet.add(value.getClass());
            }
            for (Class clazz : classSet) {
                indexUpdater.flush(PojoIndexedTypeIdentifier.convertFromLegacy((Class)clazz));
            }
        }
        return null;
    }

    private void preIndex(IndexUpdater indexUpdater) {
        if (this.clean) {
            indexUpdater.purge(this.indexedType);
        }
    }

    private void postIndex(IndexUpdater indexUpdater) {
        indexUpdater.waitForAsyncCompletion();
        if (this.flush) {
            indexUpdater.flush(this.indexedType);
        }
    }

    private KeyValueFilter getFilter(ClusteringDependentLogic clusteringDependentLogic, DataConversion keyDataConversion) {
        return this.primaryOwner ? new PrimaryOwnersKeyValueFilter(clusteringDependentLogic, keyDataConversion) : AcceptAllKeyValueFilter.getInstance();
    }

    private Object extractValue(Object storageValue, DataConversion valueDataConversion) {
        return valueDataConversion.extractIndexable(storageValue);
    }

    private static class PrimaryOwnersKeyValueFilter
    implements KeyValueFilter<Object, Object> {
        private final ClusteringDependentLogic clusteringDependentLogic;
        private final DataConversion keyDataConversion;

        private PrimaryOwnersKeyValueFilter(ClusteringDependentLogic clusteringDependentLogic, DataConversion keyDataConversion) {
            this.clusteringDependentLogic = clusteringDependentLogic;
            this.keyDataConversion = keyDataConversion;
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return this.clusteringDependentLogic.getCacheTopology().getDistribution(this.keyDataConversion.toStorage(key)).isPrimary();
        }
    }

    public static final class Externalizer
    extends AbstractExternalizer<IndexWorker> {
        public Set<Class<? extends IndexWorker>> getTypeClasses() {
            return Collections.singleton(IndexWorker.class);
        }

        public void writeObject(ObjectOutput output, IndexWorker worker) throws IOException {
            output.writeObject(worker.cacheName);
            output.writeObject(PojoIndexedTypeIdentifier.convertToLegacy((IndexedTypeIdentifier)worker.indexedType));
            output.writeBoolean(worker.flush);
            output.writeBoolean(worker.clean);
            output.writeBoolean(worker.primaryOwner);
            output.writeObject(worker.keys);
        }

        public IndexWorker readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = (String)input.readObject();
            Class indexedClass = (Class)input.readObject();
            boolean flush = input.readBoolean();
            boolean clean = input.readBoolean();
            boolean primaryOwner = input.readBoolean();
            Set keys = (Set)input.readObject();
            return new IndexWorker(cacheName, PojoIndexedTypeIdentifier.convertFromLegacy((Class)indexedClass), flush, clean, primaryOwner, keys);
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_WORKER;
        }
    }
}

