/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.query.affinity.ShardDistribution;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.LogFactory;

class FixedShardsDistribution
implements ShardDistribution {
    private static final Log LOGGER = (Log)LogFactory.getLog(FixedShardsDistribution.class, Log.class);
    private final Map<Integer, String> shardPerSegmentMap = new ConcurrentHashMap<Integer, String>();
    private final Map<Address, Set<String>> shardsPerAddressMap = new ConcurrentHashMap<Address, Set<String>>();
    private final Map<String, Address> addressPerShardMap = new ConcurrentHashMap<String, Address>();
    private final int numShards;

    FixedShardsDistribution(ConsistentHash consistentHash, int numShards) {
        if (numShards > consistentHash.getNumSegments()) {
            throw new IllegalArgumentException("Number of shards cannot be higher than number of segments");
        }
        if (numShards < 0) {
            throw new IllegalArgumentException("Number of shards cannot be negative");
        }
        this.numShards = numShards;
        this.calculate(consistentHash, numShards);
    }

    private void calculate(ConsistentHash consistentHash, int numShards) {
        List nodes = consistentHash.getMembers();
        int numNodes = nodes.size();
        List<Set<Integer>> segmentsPerServer = nodes.stream().map(arg_0 -> ((ConsistentHash)consistentHash).getPrimarySegmentsForOwner(arg_0)).collect(Collectors.toList());
        int[] shardsNumPerServer = FixedShardsDistribution.allocateShardsToNodes(numShards, numNodes, segmentsPerServer);
        this.populateSegments(shardsNumPerServer, segmentsPerServer, nodes);
        LOGGER.tracef("Calculated shard distribution shardPerSegmentMap: %s", this.shardPerSegmentMap);
        LOGGER.tracef("Calculated shard distribution shardsPerAddressMap: %s", this.shardsPerAddressMap);
        LOGGER.tracef("Calculated shard distribution addressPerShardMap: %s", this.addressPerShardMap);
    }

    private void populateSegments(int[] shardsNumPerServer, List<Set<Integer>> segmentsPerServer, List<Address> nodes) {
        int shardId = 0;
        int n = 0;
        HashSet remainingSegments = new HashSet();
        for (Address node : nodes) {
            Collection primarySegments = segmentsPerServer.get(n);
            int shardQuantity = shardsNumPerServer[n];
            if (shardQuantity == 0) {
                remainingSegments.addAll(segmentsPerServer.get(n++));
                continue;
            }
            this.shardsPerAddressMap.computeIfAbsent(node, a -> new HashSet(shardQuantity));
            List segments = this.split(primarySegments, shardsNumPerServer[n++]);
            for (Collection collection : segments) {
                String id = String.valueOf(shardId++);
                collection.forEach(seg -> this.shardPerSegmentMap.put((Integer)seg, id));
                this.shardsPerAddressMap.get(node).add(id);
                this.addressPerShardMap.put(id, node);
            }
        }
        if (!remainingSegments.isEmpty()) {
            Iterator shardIterator = Stream.iterate(0, i -> (i + 1) % this.numShards).map(String::valueOf).iterator();
            for (Integer segment : remainingSegments) {
                this.shardPerSegmentMap.put(segment, (String)shardIterator.next());
            }
        }
    }

    private static int[] allocateShardsToNodes(int numShards, int numNodes, List<Set<Integer>> weightPerServer) {
        int[] shardsPerServer = new int[numNodes];
        Iterator cyclicNodeIterator = Stream.iterate(0, i -> (i + 1) % numNodes).iterator();
        while (numShards > 0) {
            int slot = (Integer)cyclicNodeIterator.next();
            if (weightPerServer.get(slot).isEmpty()) continue;
            int n = slot;
            shardsPerServer[n] = shardsPerServer[n] + 1;
            --numShards;
        }
        return shardsPerServer;
    }

    @Override
    public Set<String> getShardsIdentifiers() {
        return Collections.unmodifiableSet(this.addressPerShardMap.keySet());
    }

    @Override
    public Set<String> getShards(Address address) {
        return this.shardsPerAddressMap.get(address);
    }

    @Override
    public String getShardFromSegment(Integer segment) {
        return this.shardPerSegmentMap.get(segment);
    }

    @Override
    public Address getOwner(String shardId) {
        return this.addressPerShardMap.get(shardId);
    }
}

