/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.util.ByteString;

public class SegmentsClusteredQueryCommand
extends BaseRpcCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 105;
    private ClusteredQueryOperation clusteredQueryOperation;
    private BitSet segments;
    private AdvancedCache<?, ?> cache;

    public SegmentsClusteredQueryCommand(ByteString cacheName) {
        super(cacheName);
    }

    public SegmentsClusteredQueryCommand(String cacheName, ClusteredQueryOperation clusteredQueryOperation, BitSet segments) {
        super(ByteString.fromString((String)cacheName));
        this.clusteredQueryOperation = clusteredQueryOperation;
        this.segments = segments;
    }

    public void setSegments(BitSet segments) {
        this.segments = segments;
    }

    public BitSet getSegments() {
        return this.segments;
    }

    public QueryResponse perform(Cache<?, ?> cache) {
        return this.clusteredQueryOperation.perform(cache, this.segments);
    }

    public byte getCommandId() {
        return 105;
    }

    public boolean isReturnValueExpected() {
        return true;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.clusteredQueryOperation);
        byte[] bytes = this.segments.toByteArray();
        int length = bytes.length;
        output.write(length);
        if (length > 0) {
            output.write(bytes);
        }
    }

    public CompletableFuture<Object> invokeAsync() {
        return CompletableFuture.completedFuture(this.perform((Cache<?, ?>)this.cache));
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.clusteredQueryOperation = (ClusteredQueryOperation)input.readObject();
        int len = input.readUnsignedByte();
        BitSet bitSet = null;
        if (len > 0) {
            byte[] b = new byte[len];
            input.readFully(b);
            bitSet = BitSet.valueOf(b);
        }
        this.segments = bitSet;
    }

    public boolean canBlock() {
        return true;
    }

    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.cache = (AdvancedCache)componentRegistry.getCache().wired();
    }
}

