/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;

final class CQCreateEagerQuery
extends CQWorker {
    CQCreateEagerQuery() {
    }

    @Override
    QueryResponse perform(BitSet segments) {
        HSQuery query = this.queryDefinition.getHsQuery();
        query.afterDeserialise(this.getSearchFactory());
        this.setFilter(segments);
        try (DocumentExtractor extractor = query.queryDocumentExtractor();){
            int resultSize = query.queryResultSize();
            QueryResponse queryResponse = resultSize == 0 ? new QueryResponse(0) : new QueryResponse(this.collectKeys(extractor, query));
            return queryResponse;
        }
    }

    private NodeTopDocs collectKeys(DocumentExtractor extractor, HSQuery query) {
        TopDocs topDocs = extractor.getTopDocs();
        int topDocsLength = topDocs.scoreDocs.length;
        Object[] keys = null;
        Object[] projections = null;
        if (query.getProjectedFields() == null) {
            keys = new Object[topDocsLength];
            for (int i = 0; i < topDocsLength; ++i) {
                keys[i] = this.extractKey(extractor, i);
            }
        } else {
            projections = new Object[topDocsLength];
            try {
                for (int docIndex = 0; docIndex < topDocsLength; ++docIndex) {
                    projections[docIndex] = extractor.extract(docIndex).getProjection();
                }
            }
            catch (IOException e) {
                throw new SearchException("Error while extracting projection", (Throwable)e);
            }
        }
        return new NodeTopDocs(this.cache.getRpcManager().getAddress(), topDocs, keys, projections);
    }
}

