/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.lucene.search.BooleanQuery;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.metrics.impl.CacheMetricsRegistration;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.backend.TxQueryInterceptor;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.QueryBox;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.DefaultSearchMappingProvider;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.PersistenceContextInitializerImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.SecurityActions;
import org.infinispan.query.impl.SegmentFieldBridge;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.FullTextFilterExternalizer;
import org.infinispan.query.impl.externalizers.LuceneBooleanQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneBytesRefExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFieldDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFuzzyQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneMatchAllQueryExternalizer;
import org.infinispan.query.impl.externalizers.LucenePrefixQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneScoreDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopFieldDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneWildcardQueryExternalizer;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.xa.GlobalTransaction;

@InfinispanModule(name="query", requiredModules={"core", "query-core"}, optionalModules={"lucene-directory"})
public class LifecycleManager
implements ModuleLifecycle {
    public static final String MAX_BOOLEAN_CLAUSES_SYS_PROP = "infinispan.query.lucene.max-boolean-clauses";
    private static boolean maxBooleanClausesWasSet = false;

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE)) {
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
            ClassLoader aggregatedClassLoader = this.makeAggregatedClassLoader(cr.getGlobalComponentRegistry().getGlobalConfiguration().classLoader());
            SearchIntegrator searchFactory = null;
            boolean isIndexed = cfg.indexing().index().isEnabled();
            if (isIndexed) {
                this.setBooleanQueryMaxClauseCount(cfg.indexing().properties());
                searchFactory = this.createSearchIntegrator(cfg.indexing(), cr, aggregatedClassLoader);
                KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler(aggregatedClassLoader);
                cr.registerComponent((Object)keyTransformationHandler, KeyTransformationHandler.class);
                this.createQueryInterceptorIfNeeded(cr, cfg, cache, searchFactory, keyTransformationHandler);
                this.addCacheDependencyIfNeeded(cacheName, cache.getCacheManager(), cfg.indexing());
                cr.registerComponent((Object)new QueryBox(), QueryBox.class);
                DistributedExecutorMassIndexer massIndexer = new DistributedExecutorMassIndexer(cache, searchFactory, keyTransformationHandler, ComponentRegistryUtils.getTimeService(cache));
                cr.registerComponent((Object)massIndexer, MassIndexer.class);
            }
            cr.registerComponent((Object)ObjectReflectionMatcher.create((EntityNameResolver)new ReflectionEntityNamesResolver(aggregatedClassLoader), searchFactory), ObjectReflectionMatcher.class);
            cr.registerComponent(new QueryEngine(cache, isIndexed), QueryEngine.class);
        }
    }

    private void addCacheDependencyIfNeeded(String cacheStarting, EmbeddedCacheManager cacheManager, IndexingConfiguration indexingConfiguration) {
        if (IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingConfiguration.properties())) {
            String dataCacheName;
            String lockingCacheName;
            String metadataCacheName = IndexPropertyInspector.getMetadataCacheName((Properties)indexingConfiguration.properties());
            if (!metadataCacheName.equals(cacheStarting)) {
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, metadataCacheName);
            }
            if (!(lockingCacheName = IndexPropertyInspector.getLockingCacheName((Properties)indexingConfiguration.properties())).equals(cacheStarting)) {
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, lockingCacheName);
            }
            if (!(dataCacheName = IndexPropertyInspector.getDataCacheName((Properties)indexingConfiguration.properties())).equals(cacheStarting)) {
                SecurityActions.addCacheDependency(cacheManager, cacheStarting, dataCacheName);
            }
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, AdvancedCache<?, ?> cache, SearchIntegrator searchIntegrator, KeyTransformationHandler keyTransformationHandler) {
        Log.CONTAINER.registeringQueryInterceptor(cache.getName());
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ComponentRef queryInterceptorRef = bcr.getComponent(QueryInterceptor.class);
        if (queryInterceptorRef != null) {
            return;
        }
        ConcurrentHashMap<GlobalTransaction, Map<Object, Object>> txOldValues = new ConcurrentHashMap<GlobalTransaction, Map<Object, Object>>();
        IndexModificationStrategy indexingStrategy = IndexModificationStrategy.configuredStrategy(searchIntegrator, cfg);
        QueryInterceptor queryInterceptor = new QueryInterceptor(searchIntegrator, keyTransformationHandler, indexingStrategy, txOldValues, cache);
        for (Map.Entry kt : cfg.indexing().keyTransformers().entrySet()) {
            keyTransformationHandler.registerTransformer((Class)kt.getKey(), (Class)kt.getValue());
        }
        AsyncInterceptorChain ic = (AsyncInterceptorChain)bcr.getComponent(AsyncInterceptorChain.class).wired();
        EntryWrappingInterceptor wrappingInterceptor = (EntryWrappingInterceptor)ic.findInterceptorExtending(EntryWrappingInterceptor.class);
        AsyncInterceptor lastLoadingInterceptor = ic.findInterceptorExtending(CacheLoaderInterceptor.class);
        if (lastLoadingInterceptor == null) {
            lastLoadingInterceptor = wrappingInterceptor;
        }
        ic.addInterceptorAfter((AsyncInterceptor)queryInterceptor, lastLoadingInterceptor.getClass());
        bcr.registerComponent(QueryInterceptor.class, (Object)queryInterceptor, true);
        bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), QueryInterceptor.class.getName());
        if (cfg.transaction().transactionMode().isTransactional()) {
            TxQueryInterceptor txQueryInterceptor = new TxQueryInterceptor(txOldValues, queryInterceptor);
            ic.addInterceptorBefore((AsyncInterceptor)txQueryInterceptor, wrappingInterceptor.getClass());
            bcr.registerComponent(TxQueryInterceptor.class, (Object)txQueryInterceptor, true);
            bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), TxQueryInterceptor.class.getName());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        IndexingConfiguration indexingConfiguration = configuration.indexing();
        if (!indexingConfiguration.index().isEnabled()) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        SearchIntegrator searchFactory = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        TypedProperties indexingProperties = indexingConfiguration.properties();
        if (IndexPropertyInspector.isInfinispanDirectoryInternalCache(cacheName, (Properties)indexingProperties)) {
            Class[] indexedEntities;
            MutableSearchFactory mutableSearchFactory = (MutableSearchFactory)searchFactory.unwrap(MutableSearchFactory.class);
            mutableSearchFactory.getFilterDefinitions().remove("segmentFilter");
            for (Class clazz : indexedEntities = indexingConfiguration.indexedEntities().toArray(new Class[0])) {
                mutableSearchFactory.getProgrammaticMapping().entity(clazz).classBridge(SegmentFieldBridge.class);
            }
            searchFactory.addClasses(indexedEntities);
        }
        this.checkIndexableClasses(searchFactory, indexingConfiguration.indexedEntities());
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        MassIndexer massIndexer = ComponentRegistryUtils.getMassIndexer(cache);
        InfinispanQueryStatisticsInfo stats = new InfinispanQueryStatisticsInfo(searchFactory, massIndexer);
        stats.setStatisticsEnabled(configuration.statistics().enabled());
        cr.registerComponent((Object)stats, InfinispanQueryStatisticsInfo.class);
        this.registerQueryMBeans(cr, massIndexer, stats);
        this.registerMetrics(cr, stats);
    }

    private void registerMetrics(ComponentRegistry cr, InfinispanQueryStatisticsInfo stats) {
        CacheMetricsRegistration cacheMetricsRegistration = (CacheMetricsRegistration)cr.getComponent(CacheMetricsRegistration.class);
        if (cacheMetricsRegistration.metricsEnabled()) {
            cacheMetricsRegistration.registerMetrics((Object)stats, "query", "statistics");
        }
    }

    private void checkIndexableClasses(SearchIntegrator searchFactory, Set<Class<?>> indexedEntities) {
        for (Class<?> c : indexedEntities) {
            if (searchFactory.getIndexBinding((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(c)) != null) continue;
            throw Log.CONTAINER.classNotIndexable(c.getName());
        }
    }

    private void registerQueryMBeans(ComponentRegistry cr, MassIndexer massIndexer, InfinispanQueryStatisticsInfo stats) {
        GlobalConfiguration globalConfig = cr.getGlobalComponentRegistry().getGlobalConfiguration();
        if (globalConfig.jmx().enabled()) {
            Cache cache = (Cache)cr.getComponent(Cache.class);
            String queryGroupName = this.getQueryGroupName(globalConfig.cacheManagerName(), cache.getName());
            CacheJmxRegistration jmxRegistration = (CacheJmxRegistration)cr.getComponent(CacheJmxRegistration.class);
            try {
                jmxRegistration.registerMBean((Object)stats, queryGroupName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to register query statistics MBean", (Throwable)e);
            }
            try {
                jmxRegistration.registerMBean((Object)massIndexer, queryGroupName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to register MassIndexer MBean", (Throwable)e);
            }
        }
    }

    private String getQueryGroupName(String cacheManagerName, String cacheName) {
        return "type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchIntegrator createSearchIntegrator(IndexingConfiguration indexingConfiguration, ComponentRegistry cr, ClassLoader aggregatedClassLoader) {
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        if (searchIntegrator != null && !searchIntegrator.isStopped()) {
            throw new IllegalStateException("SearchIntegrator already initialized!");
        }
        LinkedHashSet<ProgrammaticSearchMappingProvider> programmaticSearchMappingProviders = new LinkedHashSet<ProgrammaticSearchMappingProvider>();
        programmaticSearchMappingProviders.add(new DefaultSearchMappingProvider());
        programmaticSearchMappingProviders.addAll(ServiceFinder.load(ProgrammaticSearchMappingProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader}));
        programmaticSearchMappingProviders.add((cache, mapping) -> {
            for (Class indexedEntity : indexingConfiguration.indexedEntities()) {
                mapping.entity(indexedEntity).classBridge(SegmentFieldBridge.class);
            }
        });
        Collection analyzerDefProviders = ServiceFinder.load(LuceneAnalysisDefinitionProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
        SearchableCacheConfiguration searchConfiguration = new SearchableCacheConfiguration(indexingConfiguration.indexedEntities(), (Properties)indexingConfiguration.properties(), programmaticSearchMappingProviders, analyzerDefProviders, cr, aggregatedClassLoader);
        searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)searchConfiguration).buildSearchIntegrator();
        cr.registerComponent((Object)searchIntegrator, SearchIntegrator.class);
        return searchIntegrator;
    }

    private ClassLoader makeAggregatedClassLoader(ClassLoader globalClassLoader) {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>(6);
        if (globalClassLoader != null) {
            classLoaders.add(globalClassLoader);
        }
        classLoaders.add(AggregatedClassLoader.class.getClassLoader());
        classLoaders.add(ClassLoaderService.class.getClassLoader());
        classLoaders.add(this.getClass().getClassLoader());
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                classLoaders.add(tccl);
            }
        }
        catch (Exception tccl) {
            // empty catch block
        }
        try {
            ClassLoader syscl = ClassLoader.getSystemClassLoader();
            if (syscl != null) {
                classLoaders.add(syscl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        SearchIntegrator searchIntegrator;
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor != null) {
            queryInterceptor.prepareForStopping();
        }
        if ((searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class)) != null) {
            searchIntegrator.close();
        }
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_BOOLEAN, new LuceneBooleanQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_TERM, new LuceneTermQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TERM, new LuceneTermExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT, new LuceneSortExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT_FIELD, new LuceneSortFieldExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_TOPDOCS, new NodeTopDocs.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPDOCS, new LuceneTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_FIELD_SCORE_DOC, new LuceneFieldDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SCORE_DOC, new LuceneScoreDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPFIELDDOCS, new LuceneTopFieldDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_MATCH_ALL, new LuceneMatchAllQueryExternalizer());
        externalizerMap.put(ExternalizerIds.INDEX_WORKER, new IndexWorker.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_BYTES_REF, new LuceneBytesRefExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_PREFIX, new LucenePrefixQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_WILDCARD, new LuceneWildcardQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_FUZZY, new LuceneFuzzyQueryExternalizer());
        externalizerMap.put(ExternalizerIds.QUERY_DEFINITION, new QueryDefinition.Externalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE, new QueryResponse.Externalizer());
        externalizerMap.put(ExternalizerIds.FULL_TEXT_FILTER, new FullTextFilterExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_OPERATION, new ClusteredQueryOperation.Externalizer());
    }

    private void setBooleanQueryMaxClauseCount(TypedProperties properties) {
        if (!maxBooleanClausesWasSet) {
            maxBooleanClausesWasSet = true;
            String maxClauseCountProp = properties.getProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP);
            if (maxClauseCountProp == null) {
                maxClauseCountProp = SecurityActions.getSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP);
            }
            if (maxClauseCountProp != null) {
                int maxClauseCount;
                try {
                    maxClauseCount = Integer.parseInt(maxClauseCountProp);
                }
                catch (NumberFormatException e) {
                    Log.CONTAINER.failedToParseSystemProperty(MAX_BOOLEAN_CLAUSES_SYS_PROP, e);
                    throw e;
                }
                int currentMaxClauseCount = BooleanQuery.getMaxClauseCount();
                if (maxClauseCount > currentMaxClauseCount) {
                    Log.CONTAINER.settingBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount);
                    BooleanQuery.setMaxClauseCount((int)maxClauseCount);
                } else {
                    Log.CONTAINER.ignoringBooleanQueryMaxClauseCount(MAX_BOOLEAN_CLAUSES_SYS_PROP, maxClauseCount, currentMaxClauseCount);
                }
            }
        }
    }
}

