/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.impl.massindex.MassIndexLock;
import org.infinispan.query.logging.Log;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;

final class DistributedMassIndexerLock
implements MassIndexLock {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedMassIndexerLock.class, Log.class);
    private final String lockName;
    private volatile ClusteredLock clusteredLock;
    private final Cache<?, ?> cache;

    DistributedMassIndexerLock(Cache<?, ?> cache) {
        this.cache = cache;
        this.lockName = String.format("massIndexer-%s", cache.getName());
    }

    @Override
    public boolean lock() {
        try {
            return (Boolean)this.getLock().tryLock().get();
        }
        catch (Exception e) {
            throw LOG.errorAcquiringMassIndexerLock(e);
        }
    }

    @Override
    public void unlock() {
        try {
            this.getLock().unlock();
        }
        catch (Exception e) {
            throw LOG.errorReleasingMassIndexerLock(e);
        }
    }

    @Override
    public boolean isAcquired() {
        return (Boolean)CompletionStages.join((CompletionStage)this.getLock().isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredLock getLock() {
        if (this.clusteredLock == null) {
            DistributedMassIndexerLock distributedMassIndexerLock = this;
            synchronized (distributedMassIndexerLock) {
                if (this.clusteredLock == null) {
                    ClusteredLockManager clusteredLockManager = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)this.cache.getCacheManager());
                    boolean isDefined = clusteredLockManager.isDefined(this.lockName);
                    if (!isDefined) {
                        clusteredLockManager.defineLock(this.lockName);
                    }
                    this.clusteredLock = clusteredLockManager.get(this.lockName);
                }
            }
        }
        return this.clusteredLock;
    }
}

