/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.SortField;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneSortFieldExternalizer
extends AbstractExternalizer<SortField> {
    private static final SortField.Type[] SORTFIELD_TYPE_VALUES = SortField.Type.values();

    public Set<Class<? extends SortField>> getTypeClasses() {
        return Collections.singleton(SortField.class);
    }

    public SortField readObject(ObjectInput input) throws IOException {
        return LuceneSortFieldExternalizer.readObjectStatic(input);
    }

    public void writeObject(ObjectOutput output, SortField sortField) throws IOException {
        LuceneSortFieldExternalizer.writeObjectStatic(output, sortField);
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_SORT_FIELD;
    }

    static void writeObjectStatic(ObjectOutput output, SortField sortField) throws IOException {
        output.writeUTF(sortField.getField());
        MarshallUtil.marshallEnum((Enum)sortField.getType(), (ObjectOutput)output);
        output.writeBoolean(sortField.getReverse());
    }

    static SortField readObjectStatic(ObjectInput input) throws IOException {
        String fieldName = input.readUTF();
        SortField.Type sortType = (SortField.Type)MarshallUtil.unmarshallEnum((ObjectInput)input, ordinal -> SORTFIELD_TYPE_VALUES[ordinal]);
        boolean reverseSort = input.readBoolean();
        return new SortField(fieldName, sortType, reverseSort);
    }
}

