/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;

public abstract class AbstractUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand {
    protected String indexName;
    protected byte[] serializedModel;

    protected AbstractUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    public void writeTo(ObjectOutput output) throws IOException {
        if (this.indexName == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeUTF(this.indexName);
        }
        MarshallUtil.marshallByteArray((byte[])this.serializedModel, (ObjectOutput)output);
    }

    public void readFrom(ObjectInput input) throws IOException {
        boolean hasIndexName = input.readBoolean();
        if (hasIndexName) {
            this.indexName = input.readUTF();
        }
        this.serializedModel = MarshallUtil.unmarshallByteArray((ObjectInput)input);
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public String getIndexName() {
        return this.indexName;
    }

    protected void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

