/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.query.indexmanager.LuceneWorkConverter;
import org.infinispan.query.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IndexUpdateCommand
extends AbstractUpdateCommand {
    public static final byte COMMAND_ID = 102;

    public IndexUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        Cache cache = (Cache)componentRegistry.getCache().wired();
        SearchIntegrator searchFactory = ComponentRegistryUtils.getSearchIntegrator(cache);
        QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        if (queryInterceptor.isStopping()) {
            throw Log.CONTAINER.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        IndexManager indexManager = searchFactory.getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        KeyTransformationHandler handler = queryInterceptor.getKeyTransformationHandler();
        List<LuceneWork> workToApply = LuceneWorkConverter.transformKeysToString(luceneWorks, handler);
        indexManager.performOperations(workToApply, null);
        return CompletableFutures.completedNull();
    }

    public byte getCommandId() {
        return 102;
    }
}

