/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.AdvancedCache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.QueryResultLoader;

final class EntityLoader
implements QueryResultLoader {
    private final AdvancedCache<?, ?> cache;
    private final KeyTransformationHandler keyTransformationHandler;
    private final DataConversion keyDataConversion;

    EntityLoader(AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.cache = cache;
        this.keyDataConversion = cache.getKeyDataConversion();
    }

    private Object decodeKey(EntityInfo entityInfo) {
        return this.keyDataConversion.fromStorage(this.keyTransformationHandler.stringToKey(entityInfo.getId().toString()));
    }

    @Override
    public Object load(EntityInfo entityInfo) {
        return this.cache.get(this.decodeKey(entityInfo));
    }

    @Override
    public List<Object> load(List<EntityInfo> entityInfos) {
        int entitiesSize = entityInfos.size();
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(entitiesSize);
        for (EntityInfo e : entityInfos) {
            keys.add(this.decodeKey(e));
        }
        Map entries = this.cache.getAll(keys);
        return new ArrayList<Object>(entries.values());
    }
}

