/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.QueryDefinition;

public class IndexedQueryImpl<E>
implements IndexedQuery<E> {
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected QueryDefinition queryDefinition;

    public IndexedQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache) {
        this.queryDefinition = queryDefinition;
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
    }

    public IndexedQueryImpl(SearchQueryBuilder searchQuery, AdvancedCache<?, ?> cache) {
        this(new QueryDefinition(searchQuery), cache);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        return Math.toIntExact(this.queryDefinition.getSearchQuery().build().fetchTotalHitCount());
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.queryDefinition.setFirstResult(firstResult);
        return this;
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.queryDefinition.setMaxResults(maxResults);
        return this;
    }

    @Override
    public CloseableIterator<E> iterator() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        List queryHits = searchQuery.fetchHits(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
        return new FilterIterator(queryHits.iterator(), Objects::nonNull);
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        List searchResult = searchQuery.fetchHits(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
        return searchResult;
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.failAfter(timeout, timeUnit);
        return this;
    }
}

