/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.TotalHits;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneTotalHitsExternalizer
extends AbstractExternalizer<TotalHits> {
    private static final TotalHits.Relation[] TOTALHITS_RELATION_VALUES = TotalHits.Relation.values();

    public Integer getId() {
        return ExternalizerIds.LUCENE_TOTAL_HITS;
    }

    public Set<Class<? extends TotalHits>> getTypeClasses() {
        return Collections.singleton(TotalHits.class);
    }

    public void writeObject(ObjectOutput output, TotalHits totalHits) throws IOException {
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)totalHits.value);
        MarshallUtil.marshallEnum((Enum)totalHits.relation, (ObjectOutput)output);
    }

    public TotalHits readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        long value = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        TotalHits.Relation relation = (TotalHits.Relation)MarshallUtil.unmarshallEnum((ObjectInput)input, ordinal -> TOTALHITS_RELATION_VALUES[ordinal]);
        return new TotalHits(value, relation);
    }
}

