package org.infinispan.query.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.partitionhandling.AvailabilityException;
import javax.annotation.Generated;
import org.infinispan.query.core.impl.Log;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.transaction.Transaction;
import org.jboss.logging.BasicLogger;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.search.mapper.common.EntityReference;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-01-10T05:29:45-0500")
public class Log_$logger extends DelegatingBasicLogger implements org.infinispan.query.logging.Log, Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String classNotIndexable = "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    protected String classNotIndexable$str() {
        return classNotIndexable;
    }
    @Override
    public final CacheConfigurationException classNotIndexable(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), classNotIndexable$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyClassNotFound(final String keyClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, keyClassNotFound$str(), keyClassName);
    }
    private static final String keyClassNotFound = "ISPN014001: Could not locate key class %s";
    protected String keyClassNotFound$str() {
        return keyClassNotFound;
    }
    @Override
    public final void couldNotInstantiateTransformerClass(final Class<?> transformer, final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotInstantiateTransformerClass$str(), transformer);
    }
    private static final String couldNotInstantiateTransformerClass = "ISPN014002: Cannot instantiate Transformer class %s";
    protected String couldNotInstantiateTransformerClass$str() {
        return couldNotInstantiateTransformerClass;
    }
    @Override
    public final void registeringQueryInterceptor(final String cacheName) {
        super.log.logf(FQCN, INFO, null, registeringQueryInterceptor$str(), cacheName);
    }
    private static final String registeringQueryInterceptor = "ISPN014003: Registering Query interceptor for cache %s";
    protected String registeringQueryInterceptor$str() {
        return registeringQueryInterceptor;
    }
    @Override
    public final void commandsBackendInitialized(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, commandsBackendInitialized$str(), indexName);
    }
    private static final String commandsBackendInitialized = "ISPN014004: Custom commands backend initialized backing index %s";
    protected String commandsBackendInitialized$str() {
        return commandsBackendInitialized;
    }
    @Override
    public final void typeIsUsingDefaultTransformer(final Class<?> keyClass) {
        super.log.logf(FQCN, WARN, null, typeIsUsingDefaultTransformer$str(), keyClass);
    }
    private static final String typeIsUsingDefaultTransformer = "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    protected String typeIsUsingDefaultTransformer$str() {
        return typeIsUsingDefaultTransformer;
    }
    private static final String cacheIsStoppingNoCommandAllowed = "ISPN014013: Cache named '%1$s' is being shut down. No longer accepting remote commands.";
    protected String cacheIsStoppingNoCommandAllowed$str() {
        return cacheIsStoppingNoCommandAllowed;
    }
    @Override
    public final CacheException cacheIsStoppingNoCommandAllowed(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheIsStoppingNoCommandAllowed$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities);
    }
    private static final String indexingEntitiesCompleted = "ISPN014014: Reindexed %1$d entities";
    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    private static final String indexingDocumentsCompleted = "ISPN014015: %1$d documents indexed in %2$d ms";
    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }
    @Override
    public final void purgingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, purgingIndex$str(), entityType);
    }
    private static final String purgingIndex = "ISPN014016: Purging instances of '%s' from the index";
    protected String purgingIndex$str() {
        return purgingIndex;
    }
    @Override
    public final void flushingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, flushingIndex$str(), entityType);
    }
    private static final String flushingIndex = "ISPN014017: Flushing index '%s'";
    protected String flushingIndex$str() {
        return flushingIndex;
    }
    private static final String cannotRunLuceneQueriesIfNotIndexed = "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return cannotRunLuceneQueriesIfNotIndexed;
    }
    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResumeSuspendedTx = "ISPN014033: Unable to resume suspended transaction %s";
    protected String unableToResumeSuspendedTx$str() {
        return unableToResumeSuspendedTx;
    }
    @Override
    public final CacheException unableToResumeSuspendedTx(final Transaction transaction, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToResumeSuspendedTx$str(), transaction), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSuspendTx = "ISPN014034: Unable to suspend transaction";
    protected String unableToSuspendTx$str() {
        return unableToSuspendTx;
    }
    @Override
    public final CacheException unableToSuspendTx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToSuspendTx$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy = "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return getPrefixWildcardOrRegexpQueriesCannotBeFuzzy;
    }
    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(final String s) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupAggregationsNotSupported = "ISPN014039: Queries containing groups or aggregations cannot be converted to an indexed query";
    protected String groupAggregationsNotSupported$str() {
        return groupAggregationsNotSupported;
    }
    @Override
    public final CacheException groupAggregationsNotSupported() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), groupAggregationsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filterNotSupportedWithQueryString = "ISPN014040: Unable to define filters, please use filters in the query string instead.";
    protected String filterNotSupportedWithQueryString$str() {
        return filterNotSupportedWithQueryString;
    }
    @Override
    public final CacheException filterNotSupportedWithQueryString() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), filterNotSupportedWithQueryString$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransformerForKey = "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    protected String noTransformerForKey$str() {
        return noTransformerForKey;
    }
    @Override
    public final CacheException noTransformerForKey(final String keyClassName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTransformerForKey$str(), keyClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToParseSystemProperty(final String propertyName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToParseSystemProperty$str(), propertyName);
    }
    private static final String failedToParseSystemProperty = "ISPN014044: Failed to parse system property %s";
    protected String failedToParseSystemProperty$str() {
        return failedToParseSystemProperty;
    }
    @Override
    public final void settingBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount) {
        super.log.logf(FQCN, INFO, null, settingBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount);
    }
    private static final String settingBooleanQueryMaxClauseCount = "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    protected String settingBooleanQueryMaxClauseCount$str() {
        return settingBooleanQueryMaxClauseCount;
    }
    @Override
    public final void ignoringBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount, final int currentMaxClauseCount) {
        super.log.logf(FQCN, WARN, null, ignoringBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount, currentMaxClauseCount);
    }
    private static final String ignoringBooleanQueryMaxClauseCount = "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return ignoringBooleanQueryMaxClauseCount;
    }
    private static final String interruptedWhileWaitingForRequestCompletion = "ISPN014050: Interrupted while waiting for completions of some batch indexing operations.";
    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return interruptedWhileWaitingForRequestCompletion;
    }
    @Override
    public final CacheException interruptedWhileWaitingForRequestCompletion(final Exception cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), interruptedWhileWaitingForRequestCompletion$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String massIndexingEntityFailures = "ISPN014051: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    protected String massIndexingEntityFailures$str() {
        return massIndexingEntityFailures;
    }
    @Override
    public final SearchException massIndexingEntityFailures(final long finalFailureCount, final EntityReference firstFailureEntity, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String massIndexerIndexingInstance = "ISPN014052: Indexing instance of entity '%s' during mass indexing";
    protected String massIndexerIndexingInstance$str() {
        return massIndexerIndexingInstance;
    }
    @Override
    public final String massIndexerIndexingInstance(final String entityName) {
        return String.format(getLoggingLocale(), massIndexerIndexingInstance$str(), entityName);
    }
    private static final String invalidPropertyKey = "ISPN014053: Invalid property key '%1$s`, it's not a string.";
    protected String invalidPropertyKey$str() {
        return invalidPropertyKey;
    }
    @Override
    public final CacheException invalidPropertyKey(final Object propertyKey) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), invalidPropertyKey$str(), propertyKey));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTypeIsIndexed = "ISPN014054: Trying to execute query `%1$s`, but no type is indexed on cache.";
    protected String noTypeIsIndexed$str() {
        return noTypeIsIndexed;
    }
    @Override
    public final CacheException noTypeIsIndexed(final String ickle) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTypeIsIndexed$str(), ickle));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String searchMappingUnavailable = "ISPN014055: Cannot index entry since the search mapping failed to initialize.";
    protected String searchMappingUnavailable$str() {
        return searchMappingUnavailable;
    }
    @Override
    public final CacheException searchMappingUnavailable() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), searchMappingUnavailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupingAndAggregationQueriesMustUseProjections = "ISPN014021: Queries containing grouping and aggregation functions must use projections.";
    protected String groupingAndAggregationQueriesMustUseProjections$str() {
        return groupingAndAggregationQueriesMustUseProjections;
    }
    @Override
    public final ParsingException groupingAndAggregationQueriesMustUseProjections() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), groupingAndAggregationQueriesMustUseProjections$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotHaveAggregationsInGroupByClause = "ISPN014022: Cannot have aggregate functions in GROUP BY clause";
    protected String cannotHaveAggregationsInGroupByClause$str() {
        return cannotHaveAggregationsInGroupByClause;
    }
    @Override
    public final IllegalStateException cannotHaveAggregationsInGroupByClause() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotHaveAggregationsInGroupByClause$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeUsedInGroupBy = "ISPN014023: Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported";
    protected String multivaluedPropertyCannotBeUsedInGroupBy$str() {
        return multivaluedPropertyCannotBeUsedInGroupBy;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInGroupBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInGroupBy$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeUsedInOrderBy = "ISPN014024: The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued";
    protected String multivaluedPropertyCannotBeUsedInOrderBy$str() {
        return multivaluedPropertyCannotBeUsedInOrderBy;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeUsedInOrderBy(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeUsedInOrderBy$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String queryMustNotUseGroupingOrAggregation = "ISPN014025: The query must not use grouping or aggregation";
    protected String queryMustNotUseGroupingOrAggregation$str() {
        return queryMustNotUseGroupingOrAggregation;
    }
    @Override
    public final IllegalStateException queryMustNotUseGroupingOrAggregation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), queryMustNotUseGroupingOrAggregation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause = "ISPN014026: The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause";
    protected String expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str() {
        return expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause;
    }
    @Override
    public final ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multivaluedPropertyCannotBeProjected = "ISPN014027: The property path '%s' cannot be projected because it is multi-valued";
    protected String multivaluedPropertyCannotBeProjected$str() {
        return multivaluedPropertyCannotBeProjected;
    }
    @Override
    public final ParsingException multivaluedPropertyCannotBeProjected(final String propertyPath) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multivaluedPropertyCannotBeProjected$str(), propertyPath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String partitionDegraded = "ISPN014042: Cannot execute query: cluster is operating in degraded mode and partition handling configuration doesn't allow reads and writes.";
    protected String partitionDegraded$str() {
        return partitionDegraded;
    }
    @Override
    public final AvailabilityException partitionDegraded() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), partitionDegraded$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
