/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.logging;

import javax.transaction.Transaction;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.search.mapper.common.EntityReference;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.query.core.impl.Log {
    public static final Log CONTAINER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONTAINER");

    @Message(value="The configured entity class %s is not indexable. Please remove it from the indexing configuration.", id=404)
    public CacheConfigurationException classNotIndexable(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not locate key class %s", id=14001)
    public void keyClassNotFound(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot instantiate Transformer class %s", id=14002)
    public void couldNotInstantiateTransformerClass(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Registering Query interceptor for cache %s", id=14003)
    public void registeringQueryInterceptor(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Custom commands backend initialized backing index %s", id=14004)
    public void commandsBackendInitialized(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable", id=14009)
    public void typeIsUsingDefaultTransformer(Class<?> var1);

    @Message(value="Cache named '%1$s' is being shut down. No longer accepting remote commands.", id=14013)
    public CacheException cacheIsStoppingNoCommandAllowed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reindexed %1$d entities", id=14014)
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%1$d documents indexed in %2$d ms", id=14015)
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Purging instances of '%s' from the index", id=14016)
    public void purgingIndex(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushing index '%s'", id=14017)
    public void flushingIndex(String var1);

    @Message(value="Cannot run Lucene queries on a cache '%s' that does not have indexing enabled", id=14019)
    public IllegalStateException cannotRunLuceneQueriesIfNotIndexed(String var1);

    @Message(value="Unable to resume suspended transaction %s", id=14033)
    public CacheException unableToResumeSuspendedTx(Transaction var1, @Cause Throwable var2);

    @Message(value="Unable to suspend transaction", id=14034)
    public CacheException unableToSuspendTx(@Cause Throwable var1);

    @Message(value="Prefix, wildcard or regexp queries cannot be fuzzy: %s", id=14036)
    public ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(String var1);

    @Message(value="Queries containing groups or aggregations cannot be converted to an indexed query", id=14039)
    public CacheException groupAggregationsNotSupported();

    @Message(value="Unable to define filters, please use filters in the query string instead.", id=14040)
    public CacheException filterNotSupportedWithQueryString();

    @Message(value="Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.", id=14043)
    public CacheException noTransformerForKey(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to parse system property %s", id=14044)
    public void failedToParseSystemProperty(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d", id=14046)
    public void settingBooleanQueryMaxClauseCount(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()", id=14047)
    public void ignoringBooleanQueryMaxClauseCount(String var1, int var2, int var3);

    @Message(value="Interrupted while waiting for completions of some batch indexing operations.", id=14050)
    public CacheException interruptedWhileWaitingForRequestCompletion(@Cause Exception var1);

    @Message(value="%1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s", id=14051)
    public SearchException massIndexingEntityFailures(long var1, EntityReference var3, String var4, @Cause Throwable var5);

    @Message(value="Indexing instance of entity '%s' during mass indexing", id=14052)
    public String massIndexerIndexingInstance(String var1);

    @Message(value="Invalid property key '%1$s`, it's not a string.", id=14053)
    public CacheException invalidPropertyKey(Object var1);

    @Message(value="Trying to execute query `%1$s`, but no type is indexed on cache.", id=14054)
    public CacheException noTypeIsIndexed(String var1);
}

