/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.api.TestEntity;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.ReplaceTest")
public class ReplaceTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(TestEntity.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplaceSimple() {
        EmbeddedCacheManager simpleCacheManager = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(true));
        try {
            Cache simpleCache = simpleCacheManager.getCache();
            TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
            TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
            simpleCache.put((Object)se1.getId(), (Object)se1);
            TestEntity se1ret = (TestEntity)simpleCache.replace((Object)se2.getId(), (Object)se2);
            AssertJUnit.assertEquals((Object)se1, (Object)se1ret);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{simpleCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{simpleCacheManager});
    }

    public void testReplaceSimpleSearchable() {
        TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
        TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
        this.cache.put((Object)se1.getId(), (Object)se1);
        TestEntity se1ret = (TestEntity)this.cache.replace((Object)se2.getId(), (Object)se2);
        AssertJUnit.assertEquals((Object)se1, (Object)se1ret);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testReplaceSimpleSearchableConditional() {
        TestEntity se1 = new TestEntity("name1", "surname1", 10L, "note");
        TestEntity se2 = new TestEntity("name2", "surname2", 10L, "note");
        this.cache.put((Object)se1.getId(), (Object)se1);
        assert (this.cache.replace((Object)se2.getId(), (Object)se1, (Object)se2));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }
}

