/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Date;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.backend.Bond;
import org.infinispan.query.backend.Debenture;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.MultipleEntitiesTest")
public class MultipleEntitiesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(false);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Bond.class).addIndexedEntity(Debenture.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    @Test
    public void testIndexAndQuery() {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        this.cache.put((Object)123405, (Object)new Bond(new Date(System.currentTimeMillis()), 450L));
        this.cache.put((Object)123502, (Object)new Debenture("GB", 116.0));
        this.cache.put((Object)223456, (Object)new Bond(new Date(System.currentTimeMillis()), 550L));
        Query query = queryFactory.create("FROM " + Bond.class.getName());
        Query query2 = queryFactory.create("FROM " + Debenture.class.getName());
        Assert.assertEquals((int)(query.list().size() + query2.list().size()), (int)3);
        Query queryBond = queryFactory.create("FROM " + Bond.class.getName());
        Assert.assertEquals((long)queryBond.execute().hitCount().orElse(-1L), (long)2L);
        Query queryDeb = queryFactory.create("FROM " + Debenture.class.getName());
        Assert.assertEquals((long)queryDeb.execute().hitCount().orElse(-1L), (long)1L);
    }
}

