/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.DirectoryReader;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryTest")
public class ClusteredQueryTest
extends MultipleCacheManagersTest {
    static final int NUM_ENTRIES = 50;
    Cache<String, Person> cacheAMachine1;
    Cache<String, Person> cacheAMachine2;
    private Query<Person> cacheQuery;
    protected String queryString = String.format("FROM %s where blurb:'blurb1?'", Person.class.getName());
    private final String allPersonsQuery = "FROM " + Person.class.getName();
    protected QueryFactory queryFactory1;
    protected QueryFactory queryFactory2;

    public Object[] factory() {
        return new Object[]{new ClusteredQueryTest().storageType(StorageType.OFF_HEAP), new ClusteredQueryTest().storageType(StorageType.BINARY), new ClusteredQueryTest().storageType(StorageType.OBJECT)};
    }

    @AfterMethod
    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.clustering().hash().numOwners(this.numOwners()).indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        if (this.storageType != null) {
            cacheCfg.memory().storageType(this.storageType);
        }
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.cacheAMachine1 = this.cache(0);
        this.cacheAMachine2 = this.cache(1);
        this.queryFactory1 = Search.getQueryFactory(this.cacheAMachine1);
        this.queryFactory2 = Search.getQueryFactory(this.cacheAMachine2);
        this.populateCache();
    }

    protected CacheMode getCacheMode() {
        return CacheMode.REPL_SYNC;
    }

    protected int numOwners() {
        return (Integer)HashConfiguration.NUM_OWNERS.getDefaultValue();
    }

    protected void prepareTestData() {
        IntStream.range(0, 50).boxed().map(i -> new Person("name" + i, "blurb" + i, (int)i)).forEach(p -> {
            Cache<String, Person> cache = p.getAge() % 2 == 0 ? this.cacheAMachine1 : this.cacheAMachine2;
            cache.put((Object)p.getName(), p);
        });
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(enabled=false)
    public void testLazyOrdered() {
        Query<Person> cacheQuery = this.createSortedQuery();
        for (int i = 0; i < 2; ++i) {
            try (CloseableIterator iterator = cacheQuery.iterator();){
                AssertJUnit.assertEquals((long)10L, (long)cacheQuery.execute().hitCount().orElse(-1L));
                int previousAge = 0;
                while (iterator.hasNext()) {
                    Person person = (Person)iterator.next();
                    Assert.assertTrue((person.getAge() > previousAge ? 1 : 0) != 0);
                    previousAge = person.getAge();
                }
                continue;
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(enabled=false)
    public void testLazyNonOrdered() {
        try (CloseableIterator ignored = this.cacheQuery.iterator();){
            AssertJUnit.assertEquals((long)10L, (long)this.cacheQuery.execute().hitCount().orElse(-1L));
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testLocalQuery() {
        Query localQuery1 = this.queryFactory1.create(this.queryString);
        List results1 = localQuery1.execute().list();
        Query localQuery2 = this.queryFactory1.create(this.queryString);
        List results2 = localQuery2.execute().list();
        AssertJUnit.assertEquals((int)10, (int)results1.size());
        AssertJUnit.assertEquals((int)10, (int)results2.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testEagerOrdered() {
        Query<Person> cacheQuery = this.createSortedQuery();
        try (CloseableIterator iterator = cacheQuery.iterator();){
            AssertJUnit.assertEquals((long)10L, (long)cacheQuery.execute().hitCount().orElse(-1L));
            int previousAge = 0;
            while (iterator.hasNext()) {
                Person person = (Person)iterator.next();
                Assert.assertTrue((person.getAge() > previousAge ? 1 : 0) != 0);
                previousAge = person.getAge();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testIteratorNextOutOfBounds() {
        this.cacheQuery.maxResults(1);
        try (CloseableIterator iterator = this.cacheQuery.iterator();){
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            iterator.next();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() {
        this.cacheQuery.maxResults(1);
        try (CloseableIterator iterator = this.cacheQuery.iterator();){
            assert (iterator.hasNext());
            iterator.remove();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testList() {
        Query<Person> cacheQuery = this.createSortedQuery();
        QueryResult result = cacheQuery.execute();
        List results = result.list();
        AssertJUnit.assertEquals((long)10L, (long)result.hitCount().orElse(-1L));
        int previousAge = 0;
        for (Person person : results) {
            Assert.assertTrue((person.getAge() > previousAge ? 1 : 0) != 0);
            previousAge = person.getAge();
        }
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testGetResultSizeList() {
        AssertJUnit.assertEquals((int)10, (int)this.cacheQuery.execute().list().size());
    }

    public void testPagination() {
        Query<Person> cacheQuery = this.createSortedQuery();
        cacheQuery.startOffset(2L);
        cacheQuery.maxResults(1);
        QueryResult results = cacheQuery.execute();
        List list = results.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((long)10L, (long)results.hitCount().orElse(-1L));
        Person result = (Person)list.get(0);
        AssertJUnit.assertEquals((int)12, (int)result.getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test
    public void testPagination2() {
        int[] pageSizes;
        for (int pageSize : pageSizes = new int[]{1, 5, 7, 60}) {
            this.testPaginationWithoutSort(pageSize);
            this.testPaginationWithSort(pageSize, "age");
        }
    }

    private void testPaginationWithoutSort(int pageSize) {
        this.testPaginationInternal(pageSize, null);
    }

    private void testPaginationWithSort(int pageSize, String sortField) {
        this.testPaginationInternal(pageSize, sortField);
    }

    private void testPaginationInternal(int pageSize, String sortField) {
        Query<Person> paginationQuery = this.buildPaginationQuery(0, pageSize, sortField);
        int idx = 0;
        HashSet keys = new HashSet();
        while (idx < 50) {
            List results = paginationQuery.execute().list();
            results.stream().map(Person::getName).forEach(keys::add);
            paginationQuery = this.buildPaginationQuery(idx += pageSize, pageSize, sortField);
        }
        AssertJUnit.assertEquals((int)50, (int)keys.size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    private Query<Person> buildPaginationQuery(int offset, int pageSize, String sortField) {
        String sortedQuery = sortField != null ? this.allPersonsQuery + " ORDER BY " + sortField : this.allPersonsQuery;
        Query clusteredQuery = this.queryFactory1.create(sortedQuery);
        clusteredQuery.startOffset((long)offset);
        clusteredQuery.maxResults(pageSize);
        return clusteredQuery;
    }

    public void testQueryAll() {
        Query clusteredQuery = this.queryFactory1.create(this.allPersonsQuery);
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.execute().list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testFuzzyQuery() {
        this.populateCache();
        String q = String.format("FROM %s WHERE name:'name1'~2", Person.class.getName());
        Query clusteredQuery = this.queryFactory1.create(q);
        AssertJUnit.assertEquals((int)50, (int)clusteredQuery.execute().list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleMatchAllQuery() {
        Query everybody = this.queryFactory1.create(String.format("FROM %s", Person.class.getName()));
        AssertJUnit.assertEquals((int)50, (int)everybody.execute().list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastIckleTermQuery() {
        String targetName = "name2";
        Query singlePerson = this.queryFactory1.create(String.format("FROM %s p where p.name:'%s'", Person.class.getName(), targetName));
        AssertJUnit.assertEquals((int)1, (int)singlePerson.execute().list().size());
        AssertJUnit.assertEquals((String)targetName, (String)((Person)singlePerson.iterator().next()).getName());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastFuzzyIckle() {
        Query persons0to10 = this.queryFactory1.create(String.format("FROM %s p where p.name:'nome'~2", Person.class.getName()));
        AssertJUnit.assertEquals((int)10, (int)persons0to10.execute().list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastNumericRangeQuery() {
        Query infants = this.queryFactory1.create(String.format("FROM %s p where p.age between 0 and 5", Person.class.getName()));
        AssertJUnit.assertEquals((int)6, (int)infants.execute().list().size());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastProjectionIckleQuery() {
        Query onlyNames = this.queryFactory2.create(String.format("Select p.name FROM %s p", Person.class.getName()));
        List results = onlyNames.execute().list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        HashSet names = new HashSet();
        results.iterator().forEachRemaining(s -> names.add((String)s[0]));
        Set allNames = IntStream.range(0, 50).boxed().map(i -> "name" + i).collect(Collectors.toSet());
        AssertJUnit.assertEquals(allNames, names);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testBroadcastSortedIckleQuery() {
        Query theLastWillBeFirst = this.queryFactory2.create(String.format("FROM %s p order by p.age desc", Person.class.getName()));
        List results = theLastWillBeFirst.execute().list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    public void testPaginatedIckleQuery() {
        Query q = this.queryFactory1.create(String.format("FROM %s p order by p.age", Person.class.getName()));
        q.startOffset(5L);
        q.maxResults(10);
        List results = q.execute().list();
        AssertJUnit.assertEquals((int)10, (int)results.size());
        AssertJUnit.assertEquals((String)"name5", (String)((Person)results.iterator().next()).getName());
        AssertJUnit.assertEquals((String)"name14", (String)((Person)results.get(9)).getName());
    }

    private int countLocalIndex(Cache<String, Person> cache) throws IOException {
        DirectoryReader indexReader = IndexAccessor.of(cache, Person.class).getIndexReader();
        return indexReader.numDocs();
    }

    @Test
    public void testHybridQueryWorks() {
        Query hybridQuery = this.queryFactory1.create(String.format("FROM %s p where p.nonIndexedField = 'nothing'", Person.class.getName()));
        hybridQuery.execute();
    }

    @Test
    public void testAggregationQueriesWork() {
        Query aggregationQuery = this.queryFactory1.create(String.format("SELECT p.name FROM %s p where p.name:'name3' group by p.name", Person.class.getName()));
        aggregationQuery.execute().list();
    }

    @Test
    public void testBroadcastNativeInfinispanHybridQuery() {
        String q = "FROM " + Person.class.getName() + " where age >= 40 and nonIndexedField = 'na'";
        Query query = this.queryFactory1.create(q);
        AssertJUnit.assertEquals((int)10, (int)query.execute().list().size());
    }

    @Test
    public void testBroadcastNativeInfinispanFuzzyQuery() {
        String q = String.format("FROM %s p where p.name:'nome'~2", Person.class.getName());
        Query query = Search.getQueryFactory(this.cacheAMachine1).create(q);
        AssertJUnit.assertEquals((int)10, (int)query.execute().list().size());
    }

    @Test
    public void testBroadcastSortedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine1);
        Query sortedQuery = queryFactory.create("FROM " + Person.class.getName() + " p order by p.age desc");
        List results = sortedQuery.execute().list();
        AssertJUnit.assertEquals((int)50, (int)results.size());
        AssertJUnit.assertEquals((int)49, (int)((Person)results.iterator().next()).getAge());
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    @Test(enabled=false)
    public void testIckleProjectionsLazyRetrieval() {
        String query = String.format("SELECT name, blurb FROM %s p ORDER BY age", Person.class.getName());
        Query cacheQuery = this.queryFactory1.create(query);
        CloseableIterator iterator = cacheQuery.iterator();
        List values = this.toList((Iterator)iterator);
        for (int i = 0; i < 50; ++i) {
            Object[] projection = (Object[])values.get(i);
            AssertJUnit.assertEquals((Object)projection[0], (Object)("name" + i));
            AssertJUnit.assertEquals((Object)projection[1], (Object)("blurb" + i));
        }
    }

    private <E> List<E> toList(Iterator<E> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false).collect(Collectors.toList());
    }

    @Test
    public void testBroadcastAggregatedInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query hybridQuery = queryFactory.create("select name FROM " + Person.class.getName() + " WHERE name : 'na*' group by name");
        AssertJUnit.assertEquals((int)50, (int)hybridQuery.execute().list().size());
    }

    @Test
    public void testNonIndexedBroadcastInfinispanQuery() {
        QueryFactory queryFactory = Search.getQueryFactory(this.cacheAMachine2);
        Query slowQuery = queryFactory.create("FROM " + Person.class.getName() + " WHERE nonIndexedField LIKE 'na%'");
        AssertJUnit.assertEquals((int)50, (int)slowQuery.execute().list().size());
    }

    protected void populateCache() {
        this.prepareTestData();
        this.cacheQuery = Search.getQueryFactory(this.cacheAMachine1).create(this.queryString);
        StaticTestingErrorHandler.assertAllGood(this.cacheAMachine1, this.cacheAMachine2);
    }

    protected Query<Person> createSortedQuery() {
        String q = String.format("FROM %s p where p.blurb:'blurb1?' order by p.age'", Person.class.getName());
        return Search.getQueryFactory(this.cacheAMachine1).create(q);
    }
}

