/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.DefaultCacheInheritancePreventedTest")
public class DefaultCacheInheritancePreventedTest
extends AbstractInfinispanTest {
    @Test
    public void verifyIndexDisabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test-enbledInDefault.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), true);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), true);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("not-searchable"), false);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true);
            }
        });
    }

    public void verifyIndexEnabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), false);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), false);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true);
            }
        });
    }

    private void assertIndexingEnabled(Cache<Object, Object> cache, boolean expected) {
        SearchMapping searchMapping = null;
        try {
            searchMapping = ComponentRegistryUtils.getSearchMapping(cache);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (expected && searchMapping == null) {
            Assert.fail((String)("SearchIntegrator not found but expected for cache " + cache.getName()));
        }
        if (!expected && searchMapping != null) {
            Assert.fail((String)("SearchIntegrator not expected but found for cache " + cache.getName()));
        }
        QueryInterceptor queryInterceptor = null;
        try {
            queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (expected && queryInterceptor == null) {
            Assert.fail((String)("QueryInterceptor not found but expected for cache " + cache.getName()));
        }
        if (!expected && queryInterceptor != null) {
            Assert.fail((String)("QueryInterceptor not expected but found for cache " + cache.getName()));
        }
    }
}

